/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin-core/mbeanapi/src/java/com/sun/appserv/management/config/ClusterConfig.java,v 1.6 2006/03/09 20:30:22 llc Exp $
 * $Revision: 1.6 $
 * $Date: 2006/03/09 20:30:22 $
 */


package com.sun.appserv.management.config;

import java.util.Map;


import com.sun.appserv.management.base.XTypes;
import com.sun.appserv.management.base.Container;



/**
	 Configuration for the &lt;cluster&gt; element.
 */
public interface ClusterConfig
	extends PropertiesAccess, SystemPropertiesAccess,
	NamedConfigElement, Container,
		ResourceRefConfigCR, ServerRefConfigCR, DeployedItemRefConfigCR
{
/** The j2eeType as returned by {@link com.sun.appserv.management.base.AMX#getJ2EEType}. */
	public static final String	J2EE_TYPE	= XTypes.CLUSTER_CONFIG;
	
	/**
		Get the name of the config element referenced by this cluster.
	 */
	public String	getReferencedConfigName();

	/**
		Calls Container.getContaineeMap( XTypes.SERVER_REF_CONFIG ).
		@return Map of ServerRefConfig MBean proxies, keyed by name.
		@see com.sun.appserv.management.base.Container#getContaineeMap
	 */
	public Map<String,ServerRefConfig>	getServerRefConfigMap();
	
	/**
		Calls Container.getContaineeMap( XTypes.RESOURCE_REF_CONFIG ).
		@return Map of ResourceRefConfig MBean proxies, keyed by name.
		@see com.sun.appserv.management.base.Container#getContaineeMap
	 */
	public Map<String,ResourceRefConfig>	getResourceRefConfigMap();
	
	/**
		Calls Container.getContaineeMap( XTypes.DEPLOYED_ITEM_REF_CONFIG ).
		@return Map of DeployedItemRefConfig MBean proxies, keyed by name.
		@see com.sun.appserv.management.base.Container#getContaineeMap
	 */
	public Map<String,DeployedItemRefConfig>	getDeployedItemRefConfigMap();

	/**
		@return Map of ClusteredServerConfig, keyed by name.
	 */
	public Map<String,ClusteredServerConfig>		getClusteredServerConfigMap();


    /**
        @since AppServer 9.0
     */
    public ClusteredServerConfig    createClusteredServerConfig(
                                        String name, String nodeAgentName,
                                         Map<String,String> optional);
    /**
        @since AppServer 9.0
     */
     public void    removeClusteredServerConfig( String name );
	
	/**
	 * Return the port used by GMS for group events.	
	 * @since AppServer 9.0
	*/
	public String getHeartbeatPort();
	/**
	 * @since AppServer 9.0
	*/
	public void setHeartbeatPort(final String port);

	/**
	 * @since AppServer 9.0
	*/
	public boolean getHeartbeatEnabled();
	/**
	 * @since AppServer 9.0
	*/
	public void setHeartbeatEnabled(final boolean enabled);

	/**
	 * @since AppServer 9.0
	*/
	public String getHeartbeatAddress();
	/**
	 * @since AppServer 9.0
	*/
	public void setHeartbeatAddress(final String address);
}
