/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.appserv.management.config;

import com.sun.appserv.management.base.XTypes;


/**
	Configuration for custom MBean.
	<p>
	When a Custom MBean is loaded, the object name specified via
	the 'ObjectNameInConfig' Attribute is used.  The JMX Domain
	will always be {@link #JMX_DOMAIN}.
	<p>
	If there is a name specified in  'ObjectNameInConfig' eg
	"name=name1", that name is used and the name as returned
	by {@link #getName} is not used within the ObjectName.
	
    <b>Questions</b>
    <ul>
    <li>
        When setEnabled( true/false ) is called, are custom MBeans dynamically
        loaded and unloaded?  Document this here.
    </li>
    <li>
        How to obtain the ObjectName for the runtime MBean that
        this config specifies?
    </li>
    <li>
        Are runtime MBeans loaded only in the DAS, or in each server?
        What about the Node Agent?  If they are loaded per server, 
        what is put into the ObjectName to distinguish them?
    </li>
    <li>
        All these either/or cases are confusing.  We should restrict
        the object-name Attribute to properties, prohibit a 'name'
        property, and require a 'type' property--my opinion--Lloyd
    </li>
    </ul>
	
	@see com.sun.appserv.management.config.DomainConfig#getCustomMBeanConfigMap
 */
public interface CustomMBeanConfig
    extends NamedConfigElement, Enabled, PropertiesAccess, ObjectType,
    DeployedItemRefConfigReferent, Description
{
/** The j2eeType as returned by {@link com.sun.appserv.management.base.AMX#getJ2EEType}. */
	public static final String	J2EE_TYPE	= XTypes.CUSTOM_MBEAN_CONFIG;
	
	/**
	    The JMX domain in which all custom MBeans are registered by default.
	 */
	public static final String  JMX_DOMAIN   = "user";
	
	/**
	    Get the ObjectName as configured (which could differ from the ObjectName
	    with which the MBean is registered--TBD).
	    This Attribute may not be changed; it is read-only.
	 */
	public String getObjectNameInConfig();
	
	/**
	    Get the implementation class.
	    This Attribute is read-only.
	 */
	public String getImplClassname();
}











