/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin-core/mbeanapi/src/java/com/sun/appserv/management/config/EJBContainerAvailabilityConfigKeys.java,v 1.3 2005/12/25 03:49:27 tcfujii Exp $
 * $Revision: 1.3 $
 * $Date: 2005/12/25 03:49:27 $
 */
package com.sun.appserv.management.config;


/**
	Parameters used by {@link AvailabilityServiceConfig} 
	when creating a new &lt;ejb-container-availability&gt; element.
	
	@see AvailabilityServiceConfig
	@see SFSBPersistenceTypeValues
 */
public final class EJBContainerAvailabilityConfigKeys
{
	private EJBContainerAvailabilityConfigKeys()	{}
	
	public static final String EJB_CONTAINER_AVAILABILITY_ENABLED_KEY	= "AvailabilityEnabled";

	/**
		Legal values are those defined in {@link SFSBPersistenceTypeValues}.
	 */
	public static final String SFSB_HA_PERSISTENCE_TYPE_KEY	= "SFSBHAPersistenceType";
	
	/**
		See {@link #SFSB_HA_PERSISTENCE_TYPE_KEY}.
	 */
	public static final String SFSB_PERSISTENCE_TYPE_KEY		= "SFSBPersistenceType";

	public static final String SFSB_CHECKPOINT_ENABLED_KEY		= "SFSBCheckPointEnabled";

	public static final String SFSB_QUICK_CHECKPOINT_ENABLED_KEY		= "SFSBQuickCheckPointEnabled";

	/**
		The jndi-name for the JDBC Connection Pool used       
        potentially by both the Web Container and the EJB Stateful    
        Session Bean Container for use in checkpointing/passivation   
        when persistence-type = {@link SFSBPersistenceTypeValues#HA}.
	 */
	public static final String SFSB_STORE_POOL_NAME_KEY		= "SFSBStorePoolName";
}

