/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.appserv.management.config;

import com.sun.appserv.management.base.XTypes;


/**
    Represents the &lt;jms-availability> element.
	@since AppServer 9.0
	@see AvailabilityServiceConfig
*/

public interface JMSAvailabilityConfig extends ConfigElement, PropertiesAccess 
{
/** The j2eeType as returned by {@link com.sun.appserv.management.base.AMX#getJ2EEType}. */
	public static final String	J2EE_TYPE	= XTypes.JMS_AVAILABILITY_CONFIG;
	
	/**                      
        This boolean flag controls whether the MQ cluster associated  
        with the application server cluster is HA enabled or not. If  
        this attribute is "false", then the MQ cluster pointed to by  
        the jms-service element is considered non-HA. JMS Messages    
        are not persisted to a highly available store. If this        
        attribute is "true" the MQ cluster pointed to by the          
        jms-service element is a HA cluster and the MQ cluster uses   
        the database pointed to by mq-store-pool-name to save         
        persistent JMS messages and other broker cluster              
        configuration information. Individual applications will not   
        be able to control or override MQ cluster availability        
        levels. They inherit the availability attribute defined in    
        this element. If this attribute is missing, availability is   
        turned off by default [i.e. the MQ cluster associated with    
        the AS cluster would behave as a non-HA cluster]
	 */
	public boolean	getAvailabilityEnabled();
	
	/**
	    @see #getAvailabilityEnabled
	 */
	public void	setAvailabilityEnabled( boolean value );

    /**                             
        This is the jndi-name for the JDBC Connection Pool used by    
        the MQ broker cluster for use in saving persistent JMS        
        messages and other broker cluster configuration information.  
        It will default to value of store-pool-name under             
        availability-service (ultimately "jdbc/hastore").
     */
	public String	getMQStorePoolName();
	
	/**
	    @see #getMQStorePoolName
	 */
	public void	setMQStorePoolName( String name );




}
