/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.appserv.management.config;

import java.util.Map;

import com.sun.appserv.management.base.XTypes;



/**
	 Configuration for the &lt;module-log-levels&gt; element.
	 
	 Values are those defined in {@link LogLevelValues}.
*/

public interface ModuleLogLevelsConfig extends PropertiesAccess, ConfigElement 
{
/** The j2eeType as returned by {@link com.sun.appserv.management.base.AMX#getJ2EEType}. */
	public static final String	J2EE_TYPE	= XTypes.MODULE_LOG_LEVELS_CONFIG;


	/**
		Get a Map keyed by Attribute name of all log levels.
		Attribute names correspond to the various get methods eg
		"Admin" for {@link #getAdmin}, "CMP" for {@link #getCMP}, etc.
		<p>
		The possible levels are as defined in {@link LogLevelValues}.
	 */
	public Map<String,String>		getAllLevels();
	
	
	/**
		Change all log levels to the specified value.
		
		@param value one of the values in {@link LogLevelValues}
	 */
	public void		changeAll( final String value );
	
	/**
	    @since AppServer 9.0
	 */
	public String getNodeAgent();
	/**
	    @since AppServer 9.0
	 */
	public void setNodeAgent( String level );
	
	/**
	    @since AppServer 9.0
	 */
	public String getUtil();
	/**
	    @since AppServer 9.0
	 */
	public void setUtil( String level );
	
	/**
	    @since AppServer 9.0
	 */
	public String getSelfManagement();
	/**
	    @since AppServer 9.0
	 */
	public void setSelfManagement( String level );
	
	/**
	    @since AppServer 9.0
	 */
	public String getSynchronization();
	/**
	    @since AppServer 9.0
	 */
	public void setSynchronization( String level );
	
	/**
	    @since AppServer 9.0
	 */
	public String getGroupManagementService();
	/**
	    @since AppServer 9.0
	 */
	public void setGroupManagementService( String level );
	
	
	/**
	    @since AppServer 9.0
	 */
	public String getManagementEvent();
	/**
	    @since AppServer 9.0
	 */
	public void setManagementEvent( String level );
	
	
	public String	getAdmin();
	/** @param value any value defined in {@link LogLevelValues} */
	public void	setAdmin( String value );

	public String	getClassloader();
	/** @param value any value defined in {@link LogLevelValues} */
	public void	setClassloader( String value );

	public String	getCMPContainer();
	/** @param value any value defined in {@link LogLevelValues} */
	public void	setCMPContainer( String value );

	public String	getCMP();
	/** @param value any value defined in {@link LogLevelValues} */
	public void	setCMP( String value );

	public String	getConfiguration();
	/** @param value any value defined in {@link LogLevelValues} */
	public void	setConfiguration( String value );

	public String	getConnector();
	/** @param value any value defined in {@link LogLevelValues} */
	public void	setConnector( String value );

	public String	getCORBA();
	/** @param value any value defined in {@link LogLevelValues} */
	public void	setCORBA( String value );

	public String	getDeployment();
	/** @param value any value defined in {@link LogLevelValues} */
	public void	setDeployment( String value );

	public String	getEJBContainer();
	/** @param value any value defined in {@link LogLevelValues} */
	public void	setEJBContainer( String value );

	public String	getJavamail();
	/** @param value any value defined in {@link LogLevelValues} */
	public void	setJavamail( String value );

	public String	getJAXR();
	/** @param value any value defined in {@link LogLevelValues} */
	public void	setJAXR( String value );

	public String	getJAXRPC();
	/** @param value any value defined in {@link LogLevelValues} */
	public void	setJAXRPC( String value );

	public String	getJDO();
	/** @param value any value defined in {@link LogLevelValues} */
	public void	setJDO( String value );

	public String	getJMS();
	/** @param value any value defined in {@link LogLevelValues} */
	public void	setJMS( String value );

	public String	getJTA();
	/** @param value any value defined in {@link LogLevelValues} */
	public void	setJTA( String value );

	public String	getJTS();
	/** @param value any value defined in {@link LogLevelValues} */
	public void	setJTS( String value );

	public String	getMDBContainer();
	/** @param value any value defined in {@link LogLevelValues} */
	public void	setMDBContainer( String value );

	public String	getNaming();
	/** @param value any value defined in {@link LogLevelValues} */
	public void	setNaming( String value );

	public String	getResourceAdapter();
	/** @param value any value defined in {@link LogLevelValues} */
	public void	setResourceAdapter( String value );

	public String	getRoot();
	/** @param value any value defined in {@link LogLevelValues} */
	public void	setRoot( String value );

	public String	getSAAJ();
	/** @param value any value defined in {@link LogLevelValues} */
	public void	setSAAJ( String value );

	public String	getSecurity();
	/** @param value any value defined in {@link LogLevelValues} */
	public void	setSecurity( String value );

	public String	getServer();
	/** @param value any value defined in {@link LogLevelValues} */
	public void	setServer( String value );

	public String	getVerifier();
	/** @param value any value defined in {@link LogLevelValues} */
	public void	setVerifier( String value );

	public String	getWebContainer();
	/** @param value any value defined in {@link LogLevelValues} */
	public void	setWebContainer( String value );





}
