/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin-core/mbeanapi/src/java/com/sun/appserv/management/config/ServerConfig.java,v 1.5 2005/12/25 03:50:03 tcfujii Exp $
 * $Revision: 1.5 $
 * $Date: 2005/12/25 03:50:03 $
 */


package com.sun.appserv.management.config;



import java.util.Map;

import com.sun.appserv.management.config.TemplateResolver;
import com.sun.appserv.management.base.Container;

/**
	Base interface for server configuration for the &lt;server&gt; element.
	Does not provide ability to access resource or application-ref; see
	{@link StandaloneServerConfig} and {@link ClusteredServerConfig}.
 */
public interface ServerConfig
	extends PropertiesAccess, SystemPropertiesAccess,
	NamedConfigElement, TemplateResolver, Container
{
	/**
		Get the name of the config element referenced by this server.
	 */
	public String		getReferencedConfigName( );
	
	/**
		Get the name of the node-agent element referenced by this server.
	 */
	public String		getReferencedNodeAgentName( );
	
	/**
		Calls Container.getContaineeMap( XTypes.DEPLOYED_ITEM_REF_CONFIG ).
		@return Map of all DeployedItemRefConfig MBean proxies, keyed by name.
		@see com.sun.appserv.management.base.Container#getContaineeMap
	 */
	public Map<String,DeployedItemRefConfig>	getDeployedItemRefConfigMap();
	
	/**
		Calls Container.getContaineeMap( XTypes.RESOURCE_REF_CONFIG ).
		@return Map of all ResourceRefConfig MBean proxies, keyed by name.
		@see com.sun.appserv.management.base.Container#getContaineeMap
	 */
	public Map<String,ResourceRefConfig>	getResourceRefConfigMap();

   
	/**
	    <b>EE only</b>
	    Return the load balancer weight for this server.
	    This is used by both IIOP and HTTP load balancer. Default value is 1.
	    @since AppServer 9.0
      */
    public String getLBWeight();
        
	/**
	    <b>EE only</b>
	    Set the load balancer weight for this server to the specified value.
	    @since AppServer 9.0
	*/
	public void setLBWeight(final String weight);
}
