/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin-core/mbeanapi/src/java/com/sun/appserv/management/config/SessionConfig.java,v 1.4 2006/03/09 20:30:25 llc Exp $
 * $Revision: 1.4 $
 * $Date: 2006/03/09 20:30:25 $
 */

package com.sun.appserv.management.config;

import java.util.Map;

import com.sun.appserv.management.base.XTypes;
import com.sun.appserv.management.base.Container;

/**
	 Configuration for the &lt;session-config&gt; element.
*/
public interface SessionConfig
	extends ConfigElement, Container
{
/** The j2eeType as returned by {@link com.sun.appserv.management.base.AMX#getJ2EEType}. */
	public static final String	J2EE_TYPE			= XTypes.SESSION_CONFIG;

	/**
		Creates new session-manager element.

		@return A proxy to the SessionManagerConfig MBean.
	 */
	public SessionManagerConfig	createSessionManagerConfig();

	/**
		Removes session-manager element.
	 */
	public void			removeSessionManagerConfig();

	/**
		Get the SessionManagerConfig MBean.
	 */
	public SessionManagerConfig	getSessionManagerConfig();

	/**
		Creates new session-properties element.

		@param	params Map of optional attrbutes and properties.
		@return A proxy to the SessionPropertiesConfig MBean.
	 */
	public SessionPropertiesConfig	createSessionPropertiesConfig( Map<String,String> params );

	/**
		Removes session-properties element.
	 */
	public void			removeSessionPropertiesConfig();

	/**
		Get the SessionPropertiesConfig MBean.
	 */
	public SessionPropertiesConfig	getSessionPropertiesConfig();
}
