/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.appserv.management.ext.logging;

import java.util.Map;
import java.util.Date;
import java.util.logging.Level;

/**
	An individual result representing a log entry found
	by {@link LogQuery#queryServerLog}.
	
	@since AS 9.0
	@see LogQueryResult
 */
public interface LogQueryEntry
{
    /**
        Get the fields associated with this entry.
        The fields are indexed by the values found in
        {@link LogRecordFields}.  A field is always non-null.
     */
    public Object[] getFields();
    
    /**
        The record number within the log file (first one is 0).
     */
    public long getRecordNumber();
    
    /**
        The name of the product.
     */
    public String getProductName();
    
     
    /**
        The Date that the log entry was emitted.
     */
    public Date     getDate();
    
    /**
        The module or Logger that emitted the entry.
     */
    public String   getModule();
    
    /**
        The Level of the entry.
     */
    public String    getLevel();
    
    /**
        The unique message ID identifying the entry.
     */
    public String   getMessageID();
    
    /**
        The free-form message.
     */
    public String   getMessage();
    
    
    /**
        Key for the thread ID within the Map returned by {@link #getNameValuePairsMap}.
        Value is of type java.lang.String.
     */
    public static final String  THREAD_ID_KEY   = "_ThreadID";
    
    /**
        Key for the ObjectName within the Map returned by {@link #getNameValuePairsMap}.
        Value is of type javax.management.ObjectName.
     */
    public static final String  OBJECT_NAME_KEY   = "_ObjectName";
    
    /**
        A Map containing name/value pairs as parsed
        from the String given by {@link #getNameValuePairs}.
        Values which are available for public use are:
        <ul>
        <li>{@link #THREAD_ID_KEY}</li>
        <li>{@link #OBJECT_NAME_KEY}</li>
        </ul>
     */
    public Map<String,String>   getNameValuePairsMap();
    
    /**
        The raw name/value pair String for this log entry.  Each
        pair is separated by the ';' character.
     */
    public String   getNameValuePairs();
    
    /**
        The ID of the thread that emitted the entry (may be null).
     */
    public String   getThreadID();
}






