/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin-core/mbeanapi/src/java/com/sun/appserv/management/j2ee/J2EETypesMapper.java,v 1.4 2005/12/25 03:50:44 tcfujii Exp $
 * $Revision: 1.4 $
 * $Date: 2005/12/25 03:50:44 $
 */
 
package com.sun.appserv.management.j2ee;

import com.sun.appserv.management.base.TypesMapper;

import com.sun.appserv.management.DomainRoot;

/**
	Map all types from J2EE Types to their respective MBean interfaces.
 */
public final class J2EETypesMapper extends TypesMapper
{
	private static J2EETypesMapper	INSTANCE	= null;
	
	
		public static synchronized J2EETypesMapper
	getInstance()
	{
		if ( INSTANCE == null )
		{
			INSTANCE	= new J2EETypesMapper();
		}
		
		return( INSTANCE );
	}
	
	
		private
	J2EETypesMapper( )
	{
		super( MBEANINTERFACES );
	}

	
	/**
		The classes for which we need mapping (all MBeans must be included)
	 */
	private static final Class[] MBEANINTERFACES	=
	{
		J2EEDomain.class,
		J2EEServer.class,
		J2EECluster.class,
		//J2EEStandaloneServer.class,
		J2EEApplication.class,
		AppClientModule.class,
		EJBModule.class,
		WebModule.class,
		ResourceAdapterModule.class,
		ResourceAdapter.class,
		EntityBean.class,
		StatefulSessionBean.class,
		StatelessSessionBean.class,
		MessageDrivenBean.class,
		Servlet.class,
		JavaMailResource.class,
		JCAResource.class,
		JCAConnectionFactory.class,
		JCAManagedConnectionFactory.class,
		JDBCResource.class,
		JDBCDataSource.class,
		JDBCDriver.class,
		JMSResource.class,
		JNDIResource.class,
		JTAResource.class,
		RMIIIOPResource.class,
		URLResource.class,
		JVM.class,
		WebServiceEndpoint.class,
	};
	
}
