/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.appserv.management.j2ee.statistics;

import java.util.Map;
import java.io.Serializable;

import com.sun.appserv.management.util.misc.MapUtil;
import com.sun.appserv.management.util.misc.ObjectUtil;
import com.sun.appserv.management.util.misc.TypeCast;

/**
	Implements getXXX() based on a Map whose keys are the XXX part of the getXXX() method name.
	Serializable so that it may be used to return a result remotely.
	<br><b>Internal use only</b>
 */
public class MapGetterInvocationHandler<T>
	extends GetterInvocationHandler<T>
	implements Serializable 
{
	static final long serialVersionUID = -8751876448821319456L;

	private final Map<String,T>	mMap;
	
	/**
		Create a new instance using the Map, which is <b>not</b> copied.
	 */
		public
	MapGetterInvocationHandler( final Map<String,T> map )
	{
		mMap	= map;
	}
	
		protected Map<String,T>
	getMap()
	{
		return( mMap );
	}
	
		protected T
	getValue( final String name )
	{
		return( mMap.get( name ) );
	}

		protected boolean
	containsValue( String name )
	{
		return( mMap.containsKey( name ) );
	}
	
 	    public int
 	hashCode()
 	{
 	    return ObjectUtil.hashCode( mMap );
 	}
	
		public boolean
	equals( final Object rhsIn )
	{
		boolean	equals	= false;
		
		if ( rhsIn instanceof MapGetterInvocationHandler )
		{
		    final MapGetterInvocationHandler<?> rhs = 
		        MapGetterInvocationHandler.class.cast( rhsIn );
		        
			equals	= MapUtil.mapsEqual( getMap(), rhs.getMap() );
		}
		 
		return( equals );
	}
	
	
		public String
	toString( )
	{
		return( MapUtil.toString( mMap ) );
	}
}





