/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.appserv.management.monitor.statistics;

import javax.management.j2ee.statistics.Stats;
import javax.management.j2ee.statistics.CountStatistic;
import javax.management.j2ee.statistics.BoundedRangeStatistic;
import javax.management.j2ee.statistics.RangeStatistic;

import com.sun.appserv.management.j2ee.statistics.StringStatistic;

/**
	@see com.sun.appserv.management.monitor.ConnectionQueueMonitor
 */
public interface ConnectionQueueStats extends Stats
{
    /** 
        Gets the total number of connections that have been queued.
        <p>
        A given connection may be queued multiple times, so
        <code>CountTotalQueued</code> may be greater than or equal to
        <code>CountTotalConnections</code>.
     
        @return number of connections queued
     */        
	public CountStatistic	getCountTotalQueued();
	
    /** 
        Gets the number of times the queue has been too full to accommodate
        a connection
     * @return number of overflows
     */    
	public CountStatistic	getCountOverflows();
	 
    /**
        @return total number of connections that have been accepted.
     */   
	public CountStatistic	getCountTotalConnections();
	
    /** 
        Gets the average number of connections queued in the last 5 minutes
     
     @return average
     */    
	public CountStatistic	getCountQueued5MinuteAverage();
	
    /**
        Gets the total number of ticks that connections have spent in the
        queue. A tick is a system-dependent unit of time.
     @return number of ticks
     */    
	public CountStatistic	getTicksTotalQueued();
	
    /** 
        Gets the average number of connections queued in the last 1 minute
     
        @return average number
     */    
	public CountStatistic	getCountQueued1MinuteAverage();
	
    /** 
        Gets the average number of connections queued in the last 15 minutes
        @return average number
     */    
	public CountStatistic	getCountQueued15MinuteAverage();
	
    /**
        Gets the maximum size of the connection queue
        @return the maximum size
     */    
	public CountStatistic	getMaxQueued();
	
    /**
        Gets the largest number of connections that were in the queue
        simultaneously.
     
        @return the count
     */    
	public CountStatistic	getPeakQueued();
	
    /** 
        @return The ID of the connection queue
     */
	public StringStatistic	getID();
	
    /**
     * @return number of connections currently in the queue
     */    
	public CountStatistic	getCountQueued();
}
