/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * $Id: EJBCacheStats.java,v 1.3 2005/12/25 03:51:13 tcfujii Exp $
 * $Date: 2005/12/25 03:51:13 $
 * $Revision: 1.3 $
 */

package com.sun.appserv.management.monitor.statistics;
import javax.management.j2ee.statistics.Stats;
import javax.management.j2ee.statistics.CountStatistic;
import javax.management.j2ee.statistics.BoundedRangeStatistic;

/**
 * A Stats interface to represent the statistics exposed by the Enterprise Bean Cache.
 * This is based on the statistics that were exposed in S1AS7.0. An implementation of EJB Cache
 * should provide statistical data by implementing this interface.
 */
public interface EJBCacheStats extends Stats
{
    
    /**
     * Returns the number of times a user request fails to find an EJB in associated EJB cache instance, as a CountStatistic.
     * @return		an instance of {@link BoundedRangeStatistic}
     */
    public BoundedRangeStatistic getCacheMisses();
    
    /**
     * Returns the number of times a user request hits an EJB in associated EJB cache instance, as a CountStatistic.
	 * @return		an instance of {@link BoundedRangeStatistic}
     */
    public BoundedRangeStatistic getCacheHits();
    
    /** Returns total number of EJBs in the associated EJB Cache, as a BoundedRangeStatistic. 
	 * Note that this returns the various statistical values like maximum and minimum value attained
	 * as a part of the return value.
	 * @return		an instance of {@link BoundedRangeStatistic}
     */
    public BoundedRangeStatistic getBeansInCache();
    
    /**
     * Returns the number of passivations of a Stateful Session Bean, as a CountStatistic.
	 * @return		an instance of {@link CountStatistic}
     */
    public CountStatistic getPassivations();
    
    /**
     * Returns the number of errors in passivating a Stateful Session Bean, as a CountStatistic.
	 * Must be less than or equal to {@link #getPassivations}
	 * @return		an instance of {@link CountStatistic}
     */
    public CountStatistic getPassivationErrors();
    
    /**
     * Returns the number of removed Expired Sessions as a CountStatistic.
	 * @return		an instance of {@link CountStatistic}
     */
    public CountStatistic getExpiredSessionsRemoved();
    
    /**
     * Returns the number of errors in passivating a Stateful Session Bean, as a CountStatistic.
	 * Must be less than or equal to {@link #getPassivations}
	 * @return		an instance of {@link CountStatistic}
     */
    public CountStatistic getPassivationSuccesses();
}
