/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin-core/mbeanapi/src/java/com/sun/appserv/management/util/jmx/stringifier/MBeanFeatureInfoStringifier.java,v 1.3 2005/12/25 03:51:35 tcfujii Exp $
 * $Revision: 1.3 $
 * $Date: 2005/12/25 03:51:35 $
 */
 
package com.sun.appserv.management.util.jmx.stringifier;

import com.sun.appserv.management.util.misc.ClassUtil;

import java.lang.reflect.Array;
import javax.management.MBeanParameterInfo;

import com.sun.appserv.management.util.stringifier.Stringifier;
import com.sun.appserv.management.util.stringifier.ArrayStringifier;
	
public class MBeanFeatureInfoStringifier
{
	final MBeanFeatureInfoStringifierOptions	mOptions;
	
	public static final MBeanFeatureInfoStringifierOptions	DEFAULT =
			new MBeanFeatureInfoStringifierOptions( true, ",");
	
	static final String sOperationDelimiter	= ",";
	
	MBeanFeatureInfoStringifier()
	{
		mOptions	= DEFAULT;
	}
	
	MBeanFeatureInfoStringifier( MBeanFeatureInfoStringifierOptions options )
	{
		mOptions	= options;
	}
	

	
		static String
	getPresentationTypeString( String type )
	{
		return( ClassUtil.getFriendlyClassname( type ) );
	}
	
	
		static String
	ParamsToString( final MBeanParameterInfo [] params, final MBeanFeatureInfoStringifierOptions options )
	{
		String	result	= "";
		
		if ( Array.getLength( params ) != 0 )
		{
			result	= ArrayStringifier.stringify( params,
							options.mArrayDelimiter,
							new MBeanParameterInfoStringifier( options ) );
		}
		else
		{
			result	= "void";
		}
		return( result );
	}

	
	
}