/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

/*
 * PWCFileCacheStats.java
 *
 * Created on April 2, 2004, 10:40 AM
 */

package com.sun.enterprise.admin.monitor.stats;

/**
 *
 * @author  nsegura
 */

import javax.management.j2ee.statistics.Stats;
import javax.management.j2ee.statistics.CountStatistic;

/** Provides statistical information on the httpservice file cache */
public interface PWCFileCacheStats extends Stats {
    
    /** 
     * Returns whether the file cache us enabled. 1 of enabled, 0 otherwise
     * @return enabled
     */
    public CountStatistic getFlagEnabled();
    
    /** 
     * The maximum age of a valid cache entry
     * @return cache entry max age
     */
    public CountStatistic getSecondsMaxAge();
    
    /** 
     * The number of current cache entries.  A single cache entry represents a single URI
     * @return current cache entries
     */
    public CountStatistic getCountEntries();
    
    /** The maximum number of cache entries
     * @return max cache entries
     */
    public CountStatistic getMaxEntries();
    
    /** 
     * The number of current open cache entries
     * @return open cache entries
     */
    public CountStatistic getCountOpenEntries();
    
    /** 
     * The Maximum number of open cache entries
     * @return Max open cache entries
     */
    public CountStatistic getMaxOpenEntries();
    
    /** 
     * The  Heap space used for cache
     * @return heap size
     */
    public CountStatistic getSizeHeapCache();
    
    /** 
     * The Maximum heap space used for cache
     * @return Max heap size
     */
    public CountStatistic getMaxHeapCacheSize();
    
    /** 
     * The size of Mapped memory used for caching
     * @return Mapped memory size
     */
    public CountStatistic getSizeMmapCache();
    
    /** 
     * The Maximum Memory Map size to be used for caching
     * @return Max Memory Map size
     */
    public CountStatistic getMaxMmapCacheSize();
    
    /** 
     * The Number of cache lookup hits
     * @return cache hits
     */
    public CountStatistic getCountHits();
    
    /** 
     * The Number of cache lookup misses
     * @return cache misses
     */
    public CountStatistic getCountMisses();
    
    /** 
     * The Number of hits on cached file info
     * @return hits on cached file info
     */
    public CountStatistic getCountInfoHits();
    
    /** 
     * The Number of misses on cached file info
     * @return misses on cache file info
     */
    public CountStatistic getCountInfoMisses();
    
    /** 
     * The Number of hits on cached file content
     * @return hits on cache file content
     */
    public CountStatistic getCountContentHits();
    
    /** 
     * The Number of misses on cached file content
     * @return missed on cached file content
     */
    public CountStatistic getCountContentMisses();
    
}
