/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

/*
 * MonitoringRegistrationHelperTest.java
 * JUnit based test
 *
 * Created on July 31, 2003, 3:19 PM
 */

package com.sun.enterprise.admin.monitor.util;

import junit.framework.*;
import javax.management.j2ee.statistics.*;
import javax.management.*;

/**
 * Unit test for MonitoringRegistrationHelper class.
 * @author Shreedhar Ganapathy
 */
public class MonitoringRegistrationHelperTest extends TestCase {
    //public void testRegisterIIOPServiceStats(){
    //   mrh.registerIIOPServiceStats()
    //}
    /*public void testRegisterJVMStats(){
        Stats jvmStats = new JVMStatsImpl();
        mrh.registerJVMStats(jvmStats);
        assertEquals(true, mrh.isRegistered(jvmStats));
    }*/
    
    public void testRegisteredMBean(){
        Stats stats = new S1ASJVMStatsImplMock();
        try{
            boolean done = mrh.registerStats(stats, "JVMStats");
            assertTrue(done);         
            MBeanServer server = (MBeanServer) (MBeanServerFactory.findMBeanServer(null)).get(0);
            assertNotNull(server);
            ObjectName obj = new ObjectName("defaultDomain:name=JVMStats,type=statsMonitor");
            MBeanInfo mInfo = (MBeanInfo)server.getMBeanInfo(obj);
            assertNotNull(mInfo);
            MBeanAttributeInfo[] attrInfo = mInfo.getAttributes();
            assertNotNull(attrInfo);
            for(int i=0; i<attrInfo.length;i++){
                String attr = attrInfo[i].getName();
                System.out.println("getting attribute:"+attr); 
                Object n =  server.getAttribute(obj,attr);
                try{
                    assertEquals(Long.class, n.getClass());
                }
                catch(Error ex){                    
                        ex.getLocalizedMessage();
                        assertEquals(String.class, n.getClass());
                }
                catch(Exception e){
                    assertNull(n);
                }
            }
        }
        catch(Exception ex){
            ex.printStackTrace();
            assertEquals(NullPointerException.class, ex.getClass());
        }        
    }
        
    public void testUnregisterStats(){
        Stats stats = new S1ASJVMStatsImplMock();
        try{
            boolean done = mrh.registerStats(stats, "JVMStats");
            assertTrue(done);
            done = mrh.unregisterStats("JVMStats");
            assertTrue(done);
        }catch(Exception e){
            e.getLocalizedMessage();
        }        
    }
    
    public void testRegisterStats(){
        Stats stats = new S1ASJVMStatsImplMock();
        try{
            boolean done = mrh.registerStats(stats, "JVMStats");
            assertTrue(done);
        }catch(Exception e){
            e.getLocalizedMessage();
        }            
    }
    
    public void testCreation(){
        assertNotNull(mrh);
    }
    
    public MonitoringRegistrationHelperTest(java.lang.String testName) {
        super(testName);
    }
    
    MonitoringRegistration mrh;
    protected void setUp() {
        mrh = MonitoringRegistrationHelper.getInstance();
    }
    
    protected void tearDown() {
        
    }
    public static Test suite() {
        TestSuite suite = new TestSuite(MonitoringRegistrationHelperTest.class);
        return suite;
    }
    
    public static void main(String[] args){
        junit.textui.TestRunner.run(suite());
    }
}
