<%--
 The contents of this file are subject to the terms 
 of the Common Development and Distribution License 
 (the License).  You may not use this file except in
 compliance with the License.
 
 You can obtain a copy of the license at 
 https://glassfish.dev.java.net/public/CDDLv1.0.html or
 glassfish/bootstrap/legal/CDDLv1.0.txt.
 See the License for the specific language governing 
 permissions and limitations under the License.
 
 When distributing Covered Code, include this CDDL 
 Header Notice in each file and include the License file 
 at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 If applicable, add the following below the CDDL Header, 
 with the fields enclosed by brackets [] replaced by
 you own identifying information: 
 "Portions Copyrighted [year] [name of copyright owner]"
 
 Copyright 2006 Sun Microsystems, Inc. All rights reserved.
--%>
<%@page import="com.sun.enterprise.tools.admingui.util.Util" %>
<%@page contentType="text/html; charset=UTF-8" info="managementRuleMonitor" language="java"%>
<%@taglib uri="/jato.tld" prefix="jato"%>
<%@taglib uri="/cc.tld" prefix="cc"%>

<jato:useViewBean type="com.iplanet.jato.view.ViewBean" className="managementRuleMonitor">

<cc:header pageTitle="managementRule.newConfig" copyrightYear="2003" name="HtmlHeader"
 baseName="com.sun.enterprise.tools.admingui.resources.Resources" bundleID="testBundle">

<!-- Form -->
<jato:form name="form">

<jato:content name="extra">
</jato:content>

<script type="text/javascript">

function mgmCheckRequired() {
    var observed = document.getElementById("observedObject");
    if (observed.value == '' || isWhitespace(observed.value)){
        alert(getMessage("managementRule.MonitorEnterObservedObject"));
        return false;
    }
    var attr = document.getElementById("observedAttr");
    if (attr.value == '' || isWhitespace(attr.value)){
        alert(getMessage("managementRule.MonitorEnterObservedAttr"));
        return false;
    }
    
    if (checkNum("period", getMessage("managementRule.MonitorReqNumericPeriod")) == false)
        return false;
        
    var type = getSelectedValue("monitorType");
    if (type!='countermonitor' && type!='gaugemonitor' && type!='stringmonitor'){
        alert(getMessage("managementRule.MonitorEnterType"));
        return false;
    }
    
    if (type=='gaugemonitor') 
        return checkGauge();
    
    if (type=='countermonitor') 
        return checkCount();
        
    if (type=='stringmonitor') 
        return checkString();
        
}

function checkGauge() {
    if (checkNum("lowThreshold", getMessage("managementRule.MonitorLowNumRequired")) == false)
        return false;
    if (checkNum("highThreshold", getMessage("managementRule.MonitorHighNumRequired")) == false)
        return false;
    var lowThreshold = document.getElementById("lowThreshold");
    var highThreshold = document.getElementById("highThreshold");
    var lowResult = (lowThreshold.value != '') && (ps_isInCharSet(lowThreshold.value, " \t\n\r") == false);
    var highResult = (highThreshold.value != '') && (ps_isInCharSet(highThreshold.value, " \t\n\r") == false);
    if (lowResult == false && highResult == false){
        lowThreshold.select();
        alert(getMessage("managementRule.MonitorEnterThreshold"));
        return false;
    }
    return true;
}

function checkCount() {
    if (checkNum("initThreshold", getMessage("managementRule.MonitorInitNumRequired")) == false)
        return false;
    if (checkNum("offset", getMessage("managementRule.MonitorOffsetNumRequired")) == false)
        return false;
    if (checkNum("modulus", getMessage("managementRule.MonitorModulusNumRequired")) == false)
        return false;
     
    var initThreshold = document.getElementById("initThreshold");
    if (initThreshold.value == '' || isWhitespace(initThreshold.value)){
        alert(getMessage("managementRule.MonitorEnterInitThreshold"));
        return false;
    }
}

function checkString() {
    var strValue = document.getElementById("strValue");
    if (strValue.value == '' || isWhitespace(strValue.value)){
        alert(getMessage("managementRule.MonitorEnterStringValue"));
        return false;
    }
}

function checkNum(field, fieldLabel){
    var result = checkForNumericValueOrEmpty(document.getElementById(field));
    if (result == false){
        alert(fieldLabel);
        return false;
    }
    return true;
}

function showSpecific(){
    var type = getSelectedValue("monitorType");
    document.getElementById('gaugeSpecific').style.display = 'none';
    document.getElementById('countSpecific').style.display = 'none';
    document.getElementById('stringSpecific').style.display = 'none';
    if( type == 'gaugemonitor'){
        document.getElementById('gaugeSpecific').style.display = 'block';
    }else
    if( type == 'countermonitor'){
        document.getElementById('countSpecific').style.display = 'block';
    }else
    if( type == 'stringmonitor'){
        document.getElementById('stringSpecific').style.display = 'block';
    }
}

</script>

<!-- Bread Crumb component -->
<cc:breadcrumbs name="BreadCrumb" bundleID="testBundle" useGrayBg="true" />

<div class="ConMgn">
<cc:alertinline name="Alert" bundleID="testBundle" />
</div>

<jato:content name="resourceStrings">
managementRule.MonitorEnterObservedObject
managementRule.MonitorEnterObservedAttr
managementRule.MonitorReqNumericPeriod
managementRule.MonitorEnterThreshold
managementRule.MonitorLowNumRequired
managementRule.MonitorHighNumRequired

managementRule.MonitorEnterType
managementRule.MonitorInitNumRequired
managementRule.MonitorEnterInitThreshold
managementRule.MonitorOffsetNumRequired
managementRule.MonitorModulusNumRequired
managementRule.MonitorEnterStringValue

</jato:content>

<!-- Page Title --> 
<cc:pagetitle name="PageTitle" bundleID="testBundle"
 pageTitleText="managementRule.newConfig" 
 showPageTitleSeparator="true"
 showPageButtonsTop="true"
 showPageButtonsBottom="false"
 pageTitleHelpMessage="managementRule.newMonitorHelp" >

<!-- PropertySheet -->
<cc:propertysheet name="managementRuleMonitor" bundleID="testBundle" addJavaScript="true"/>

</cc:pagetitle>
</jato:form>
</cc:header>
</jato:useViewBean>
