/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * CommonHandlers.java
 *
 */

package com.sun.enterprise.tools.admingui.handlers;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Stack;
import java.util.EventObject;
import java.util.StringTokenizer;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestContextImpl;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.ViewBeanManager;
import com.iplanet.jato.model.DefaultModel;
import com.iplanet.jato.model.Model;
import com.iplanet.jato.ModelManager;
import com.iplanet.jato.util.RootCauseException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.DisplayFieldImpl;
import com.iplanet.jato.view.DisplayField;
import com.iplanet.jato.view.ViewBase;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.html.SelectableGroup;
import com.iplanet.jato.view.html.OptionList;
import com.iplanet.jato.view.html.HREF;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.iplanet.jato.view.event.ViewRequestInvocationEvent;
import com.iplanet.jato.view.event.ViewCommandEvent;
import com.iplanet.jato.view.event.ChildContentDisplayEvent;

import javax.management.MBeanException;
import javax.management.ObjectName;
import javax.management.AttributeList;
import javax.management.Attribute;

import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import com.sun.appserv.management.util.misc.ExceptionUtil;

import com.sun.enterprise.tools.guiframework.view.descriptors.CCPropertySheetDescriptor;
import com.sun.enterprise.tools.guiframework.exception.FrameworkException;
import com.sun.enterprise.tools.guiframework.view.DescriptorCCPageTitle;
import com.sun.enterprise.tools.guiframework.view.DescriptorCCTabs;
import com.sun.enterprise.tools.guiframework.view.DescriptorContainerView;
import com.sun.enterprise.tools.guiframework.view.HandlerContext;
import com.sun.enterprise.tools.guiframework.view.ViewDescriptorManager;
import com.sun.enterprise.tools.guiframework.view.descriptors.ViewDescriptor;
import com.sun.enterprise.tools.guiframework.view.event.BeforeCreateEvent;
import com.sun.enterprise.tools.guiframework.view.event.ErrorEvent;

import com.sun.web.ui.model.CCActionTableModelInterface;
import com.sun.web.ui.model.CCPropertySheetModelInterface;
import com.sun.web.ui.taglib.html.CCDropDownMenuTag;
import com.sun.web.ui.taglib.pagetitle.CCPageTitleTag;
import com.sun.web.ui.view.html.CCButton;
import com.sun.web.ui.view.html.CCCheckBox;
import com.sun.web.ui.view.html.CCTextField;
import com.sun.web.ui.view.html.CCOption;
import com.sun.web.ui.view.html.CCOptionGroup;
import com.sun.web.ui.view.html.CCOptionSeparator;
import com.sun.web.ui.view.propertysheet.CCPropertySheet;
import com.sun.web.ui.view.tabs.CCTabs;

import com.sun.enterprise.tools.admingui.util.MBeanUtil;
import com.sun.enterprise.tools.admingui.util.Util;
import com.sun.enterprise.tools.admingui.ConfigProperties;
import com.iplanet.jato.view.CommandFieldBase;

/**
 *
 */
public class CommonHandlers {

    public void invokeMBean(RequestContext ctx, HandlerContext handlerCtx) {
	View view = handlerCtx.getView();
        
        Object objectName   = handlerCtx.getInputValue("objectName");
        if (objectName == null) {
            throw new FrameworkException("'objectName' is null in CommonHandlers.invokeMBean");
	}
        String methodName   = (String)handlerCtx.getInputValue("methodName");
        if (methodName == null) {
            throw new FrameworkException("'methodName' is null in CommonHandlers.invokeMBean");
	}
        ArrayList types     = (ArrayList)handlerCtx.getInputValue("types");
        ArrayList params    = (ArrayList)handlerCtx.getInputValue("params");
        
        
        Object[] paramsAndTypes = MBeanUtil.getParamsAndTypes(params, types);

        Object returnValue = null;
        try {
//            System.out.println("=====MBeanUtil.invoked.=====");
//            System.out.println("objectName="+objectName.toString());
//            System.out.println("methodName="+ methodName);
//            if (params != null){
//                System.out.println("params :: " + params.size() );
//                for(int i=0; i< params.size(); i++){
//                    System.out.println( params.get(i));
//                }
//            }
//            if (types != null){
//                System.out.println("types :: " + types.size());
//                for(int i=0; i< types.size(); i++){
//                    System.out.println( types.get(i));
//                }
//            }
            returnValue = MBeanUtil.invoke(objectName.toString(), methodName, 
                    (Object[])(paramsAndTypes[0]), (String[])(paramsAndTypes[1]));
            
        } catch (Exception ex) {
             if (ex.getCause().getCause() instanceof javax.management.InstanceNotFoundException) {
                // ignore, just return null; 
                // important for the monitoring code; don't know if monitor MBean is there or not
                if (Util.isLoggableFINE()) {
                    Util.logFINE("caught: InstanceNotFoundException");
                }
            } else {
                while (!(view instanceof DescriptorContainerView) &&
		    (view != null)) {
                    view = view.getParent();
                }
                ViewDescriptor vd = (view != null) ?
                    ((DescriptorContainerView)view).getViewDescriptor(): null;
                //System.out.println("=====MBeanUtil.invoke failed.=====");
                //System.out.println("objectName="+objectName.toString());
                //System.out.println("methodName="+ methodName);
                throw new FrameworkException(ex, vd, view);
            }
        }
        handlerCtx.setOutputValue(VALUE, returnValue);
        handlerCtx.setOutputValue("hasValue", new Boolean(returnValue != null).toString());
        //System.out.println("hasValue="+ new Boolean(returnValue != null).toString() );
    }
    
    public void getMBeanAttribute(RequestContext ctx, HandlerContext handlerCtx) {
        String objectName = (String) handlerCtx.getInputValue("objectName");
        if (objectName == null) {
            throw new FrameworkException("'objectName' is null in CommonHandlers.getMBeanAttribute");
	}
        String attributeName = (String)handlerCtx.getInputValue("attributeName");
        if (attributeName == null) {
            throw new FrameworkException("'attributeName' is null in CommonHandlers.getMBeanAttribute");
	}
        Object value = null;
        try {
            value = MBeanUtil.getAttribute(objectName, attributeName);
        } catch (Exception ex) {
            throw new FrameworkException("Error in CommonHandlers.getMBeanAttribute: ", ex);
        }
        handlerCtx.setOutputValue(VALUE, value);
    }
    
    // called to set the hidden variable in the tree view.
    public void getCurrentPageName(RequestContext ctx, HandlerContext handlerCtx) {
        handlerCtx.setOutputValue(VALUE, Util.getCurrentViewURL(ctx));
    }
    
    private boolean firstObjectSet = false;
    
    private boolean addOption(String objectName, OptionList optionList,
            CCOptionGroup optionGroup, HandlerContext ctx) {
        boolean itemsAdded = false;
        try {
            // check to see if there will be anything to display...
            //System.out.println("calling........ "+objectName+":getStatistics");
            Object [] stats = (Object []) MBeanUtil.invoke(
                objectName, "getStatistics", null, null);
            //System.out.println("called ........ "+objectName+":getStatistics "+stats.length);
            if (stats == null || stats.length == 0)
                return itemsAdded; //nothing to add
        } catch (Exception ex) {
            //System.out.println("exception: "+ex.getMessage());
            return itemsAdded;
        }
        // return the first object in the drop-down menu list.
        if (firstObjectSet == false) {
            firstObjectSet = true;
            ctx.setOutputValue("objectName",  objectName);
        }

        // add name and objectName to the drop-down menu list.
        //System.out.println("calling..... "+objectName+":getName");
        String name = (String) MBeanUtil.invoke(
            objectName, "getName", null, null);
        //System.out.println("called ..... "+objectName+":getName: "+name);
        if (optionGroup != null) {
            optionGroup.add(new CCOption(name, objectName));
            itemsAdded = true;
            //System.out.println("...... adding to OptGr: "+name);
        } else {
            optionList.add(new CCOption(name, objectName));
            //itemsAdded = true;
            //System.out.println("...... adding to OptList: "+name);
        }
        return itemsAdded;
    }
    
    private boolean fillMenuOptions(String objectName, OptionList optionList, 
            CCOptionGroup optionGroup, Stack ogStack, boolean doGrouping, 
            HandlerContext ctx) {
        boolean itemsAdded = false;
        
        ObjectName[] childObjects =  null;
        try {
            //System.out.println("calling..... "+objectName+":getChildren");
            childObjects = (ObjectName[])MBeanUtil.invoke(
                objectName, "getChildren", null, null);
            //System.out.println("called. .... "+objectName+":getChildren "+childObjects.length);
        } catch (Exception ex) {
            //System.out.println("exception: "+ex.getMessage());
            //return false;
        }
        if (childObjects != null && childObjects.length > 0) {
            CCOptionGroup og = optionGroup;
            if (doGrouping) {
                String name = (String) MBeanUtil.invoke(
                    objectName, "getName", null, null);
                og = new CCOptionGroup(name, name);
                //System.out.println("   starting new opt gr: "+name);
            }
            // add the options of this node
            itemsAdded = addOption(objectName, optionList, og, ctx);
            // add options for any child nodes
            for (int i=0; i<childObjects.length; i++) {
                //System.out.println("ChildObject: "+i+"  "+childObjects[i]);
                if (childObjects[i] != null) {
                    itemsAdded |= fillMenuOptions(childObjects[i].toString(), 
                        optionList, og, ogStack, doGrouping, ctx);
                }
            }
            if (itemsAdded && doGrouping) {
                // add the option group to the option list if anything was added
                //System.out.println("   ... adding gr to list.");
                ogStack.push(og); // add it after the parent.
                //optionList.add(og);
                return false;
            }
        } else {
            // just add an option of this objectName, if it has statistics.
            itemsAdded = addOption(objectName, optionList, optionGroup, ctx);
        }
        return itemsAdded;
    }
    
    public void populateMonitorDropDown(RequestContext ctx, HandlerContext handlerCtx) {
        // the child should be something like: com.sun.web.ui.view.html.CCDropDownMenu
        SelectableGroup dropDownChild = (SelectableGroup) handlerCtx.getView();
        
        ArrayList objs = (ArrayList) handlerCtx.getInputValue("monitorObjects");
        Boolean doGrouping = (Boolean) handlerCtx.getInputValue("doGrouping");
        OptionList optionList = new OptionList();
        Stack optGroupStack = new Stack();
        firstObjectSet = false;
        boolean itemsAdded = false;

        for ( int i=0; i<objs.size(); i++) {
            String objectName = (String)objs.get(i);
            if (objectName == null)
                continue;
            if (itemsAdded)
                optionList.add(new CCOptionSeparator());
            itemsAdded = fillMenuOptions(objectName, optionList, null,
                optGroupStack, doGrouping.booleanValue(), handlerCtx);
            while (optGroupStack.empty() == false) {
                optionList.add((CCOptionGroup)optGroupStack.pop());
            }
        }
        dropDownChild.setOptions(optionList);
    }
    
    public void populateMonitorAppsDropDown(RequestContext ctx, HandlerContext handlerCtx) {
        // the child should be something like: com.sun.web.ui.view.html.CCDropDownMenu
        SelectableGroup dropDownChild = (SelectableGroup) handlerCtx.getView();
        
        String appsObject = (String) handlerCtx.getInputValue("appsObjectName");
        ObjectName[] objs =  null;
        try {
            objs = (ObjectName[])MBeanUtil.invoke(
                appsObject, "getChildren", null, null);
        } catch (Exception ex) {
            // ignore
        }
        OptionList optionList = new OptionList();
        optionList.add(new CCOption("",""));
        if (objs != null) {
            for ( int i=0; i<objs.length; i++) {
                String name = null;
                try {
                    //System.out.println("calling........... "+objs[i]+":getName");
                    name = (String) MBeanUtil.invoke(objs[i], "getName", null, null);
                } catch (Exception ex) {
                    continue; // if can't get the name, skip it.
                }
                optionList.add(new CCOption(name, objs[i].toString()));
            }
        }
        dropDownChild.setOptions(optionList);
    }
    
    public void populateNodeAgentsDropDown(RequestContext ctx, HandlerContext handlerCtx) {
        SelectableGroup dropDownChild = (SelectableGroup) handlerCtx.getView();
        // get the parent container of the dropdown
        DescriptorContainerView parent = (DescriptorContainerView) dropDownChild.getParent();
        
        // need the child descriptor to get a parameter, retrieve from the parent descriptor.
        ViewDescriptor vd = parent.getViewDescriptor();
        ViewDescriptor cvd = vd.getChildDescriptor(dropDownChild.getName());
        
	String methodName = (String)handlerCtx.getInputValue("dropDownMethodName");
	String objectName   = (String)handlerCtx.getInputValue("dropDownObjectName");
	ArrayList params = (ArrayList)handlerCtx.getInputValue("params");
	ArrayList types = (ArrayList)handlerCtx.getInputValue("types");
        
 	if (objectName == null || methodName == null) {
	    throw new FrameworkException("objectName or methodName is null", 
                cvd, handlerCtx.getView());
	}
	try {
            Object[] objs = getNodeAgentsAsDropDown(methodName,objectName, params, types);
            String[]naNames = (String[]) objs[0];
            String[]naNamesWithHosts = (String[]) objs[1];
            OptionList optionList = new OptionList(naNamesWithHosts, naNames);
            dropDownChild.setOptions(optionList);
        } catch (Exception ex) {
	    throw new FrameworkException(ex, cvd, handlerCtx.getView());
	}
        
   }
    
    public void getNodeAgentsWithHosts(RequestContext ctx, HandlerContext handlerCtx) {
        
	String methodName = (String)handlerCtx.getInputValue("methodName");
	String objectName   = (String)handlerCtx.getInputValue("objectName");
	ArrayList params = (ArrayList)handlerCtx.getInputValue("params");
	ArrayList types = (ArrayList)handlerCtx.getInputValue("types");
        
 	if (objectName == null || methodName == null) {
	    throw new FrameworkException("objectName or methodName is null", null, handlerCtx.getView());
	}
	try { 
            Object[] objs = getNodeAgentsAsDropDown(methodName,objectName, params, types);
            handlerCtx.setOutputValue("naNames", objs[0]);
            handlerCtx.setOutputValue("naNamesWithHosts", objs[1]);
        }catch (Exception ex){
	    throw new FrameworkException(ex, null, handlerCtx.getView());
	}
   }
    
    public void addWebAppsFromEntApps(RequestContext ctx, HandlerContext handlerCtx) {
        // Extract the web modules from the enterprise apps and add them to the 
        // menu options.
        SelectableGroup dropDownChild = (SelectableGroup) handlerCtx.getView();
        OptionList options = dropDownChild.getOptions();
        
 	try {
            ObjectName[] objectNames = (ObjectName[])MBeanUtil.invoke(
                "com.sun.appserv:type=applications,category=config", 
                "getAllDeployedJ2EEApplications", 
                null, null);
            
            for (int i = 0; i < objectNames.length; i++) {
                //System.out.print(">>> objectNames[i]: " + objectNames[i]);
                String appName = objectNames[i].getKeyProperty("name");
                
                String[] modules = (String[])MBeanUtil.invoke(
                    "com.sun.appserv:type=applications,category=config", 
                    "getModuleComponents",
                    new Object[]{appName}, 
                    new String[]{"java.lang.String"});
                    
		for (int j = 0; j < modules.length; j++) {
                    //System.out.println(">>> modules[j]: " + modules[j]);
		    ObjectName moduleName = new ObjectName(modules[j]);
		    
		    String type = moduleName.getKeyProperty("j2eeType");
                    if (type != null && type.equalsIgnoreCase("WebModule")) {
                        String name = moduleName.getKeyProperty("name");
                        String entry = appName+"#"+name;
                        options.add(entry, entry);
                    }
		}
            }
	} catch (Exception ex) {
            if (Util.isLoggableFINE()) {
                Util.logFINE(ex);
            }
        }
    }
    
    // Framework callback method to dynamically fill in choices of a dropdown menu. 
    public void populateDropDown(RequestContext ctx, HandlerContext handlerCtx) {
         
        SelectableGroup dropDownChild = (SelectableGroup) getSelectableGroup(handlerCtx);
        populateDropDown(handlerCtx, dropDownChild);
        String initialValue = (String)handlerCtx.getInputValue("initialValue");
        if (initialValue == null || initialValue.length() == 0) {
            dropDownChild.setLabelForNoneSelected("    ");
	} else {
	    // Don't override what the user has already chosen -- CR#:6174991
	    if (dropDownChild.getValue() == null) {
		dropDownChild.setValue(initialValue);
	    }
	}
    }
    
    private SelectableGroup getSelectableGroup(HandlerContext handlerCtx){
        Object displayField = handlerCtx.getInputValue("displayField");
        if (displayField == null)
            displayField  = handlerCtx.getView();
        
        if (! (displayField instanceof SelectableGroup)){
             throw new FrameworkException("No displayField specified and current view is NOT a dropdown in populateDropDown");
        }
        return (SelectableGroup) displayField;
    }
    
    private void populateDropDown(HandlerContext handlerCtx, SelectableGroup dropDownChild){
        
        // get the parent container of the dropdown
        DescriptorContainerView parent = (DescriptorContainerView) dropDownChild.getParent();
        // need the child descriptor to get a parameter, retrieve from the parent descriptor.
        ViewDescriptor vd = parent.getViewDescriptor();
        ViewDescriptor cvd = vd.getChildDescriptor(dropDownChild.getName());
        
        String methodName = (String)handlerCtx.getInputValue("dropDownMethodName");
	String objectName   = (String)handlerCtx.getInputValue("dropDownObjectName");
	String attributeName = (String)handlerCtx.getInputValue("dropDownAttributeName");
	ArrayList params = (ArrayList)handlerCtx.getInputValue("params");
	ArrayList types = (ArrayList)handlerCtx.getInputValue("types");
	
        
	if (objectName == null || methodName == null) {
	    throw new FrameworkException("dropDownObjectName or dropDownMethodName is null in populateDropDown");
	}

        Object[] paramsAndTypes = MBeanUtil.getParamsAndTypes(params, types);
        // and finally fill in the menu choices.
	try {
            Object returnValue = MBeanUtil.invoke(objectName, methodName, 
                (Object[])(paramsAndTypes[0]), (String[])(paramsAndTypes[1]));
            if (returnValue == null)
                return;
            String [] choices = null;
            if (returnValue instanceof ObjectName[]) {
                ObjectName[] objectNameList = (ObjectName[])returnValue;
                choices = new String[objectNameList.length];
                if (attributeName == null)
                    attributeName = "name";
                for(int i =0; i < choices.length; i++) {
                    String dropDownChoice = (String)
                        MBeanUtil.getAttribute(objectNameList[i], attributeName);
                    choices[i] = dropDownChoice;
                }
            }
            else if (returnValue instanceof String[]) {
                choices = (String[])returnValue;
            }
	    
	    OptionList dropDownMenuOptions = new OptionList(choices,choices); // label and values
	    dropDownChild.setOptions(dropDownMenuOptions);
	} catch (Exception ex) {
	    throw new FrameworkException(ex, cvd, handlerCtx.getView());
	}
        
    }
    
    public void populateResourceAdapter(RequestContext ctx, HandlerContext handlerCtx) {
        // the child should be something like: com.sun.web.ui.view.html.CCDropDownMenu
        SelectableGroup dropDownChild = (SelectableGroup) handlerCtx.getView();
        // get the parent container of the dropdown
        DescriptorContainerView parent = (DescriptorContainerView) dropDownChild.getParent();
        
        // need the child descriptor to get a parameter, retrieve from the parent descriptor.
        ViewDescriptor vd = parent.getViewDescriptor();
        ViewDescriptor cvd = vd.getChildDescriptor(dropDownChild.getName());
        
        dropDownChild.setLabelForNoneSelected("                ");
	try {
            ObjectName[] dropDownObjectName = (ObjectName[]) MBeanUtil.invoke(
                "com.sun.appserv:type=applications,category=config", 
                "getAllDeployedConnectors", null, null);
            /*
             * we use getSystemConnectorsAllowingPoolCreation() as it doesn't expose __ds, __cp, __xa.
             *           
            String[] systemConnectors = 
                (String[]) MBeanUtil.invoke("com.sun.appserv:type=applications,category=config", 
                "getAllSystemConnectors", null, null);
             */
            
            String[] systemConnectors = 
                (String[]) MBeanUtil.invoke("com.sun.appserv:type=resources,category=config", 
                "getSystemConnectorsAllowingPoolCreation", null, null);
            
            //We can remove the catch after backend implemented the method.
            String[] embeddedConnectors = null;
            try {
                String[] types = new String[]{"java.lang.String", "java.lang.String"};
                Object[] params = new Object[]{null, "domain" }; 
                embeddedConnectors = (String[]) MBeanUtil.invoke(
                    "com.sun.appserv:type=applications,category=config", 
                    "getEmbeddedConnectorNames", params, types);
            }catch(Exception ex){
                Util.logINFO("Exception when calling getEmbeddedConnectorNames");
                ex.printStackTrace();
            }

            /*  API used in 7.0
            ObjectName[] dropDownObjectName = (ObjectName[]) MBeanUtil.invoke("com.sun.appserv:type=applications,category=config", 
               "getAllDeployedConnectors", null, null);
            
             String[] systemConnectors = 
                (String[]) MBeanUtil.invoke("com.sun.appserv:type=resources,category=config", 
                "getSystemConnectorsAllowingPoolCreation", null, null);
             */
            
            int numAdapters = 
                (dropDownObjectName==null?0:dropDownObjectName.length) +
                (embeddedConnectors==null?0:embeddedConnectors.length) +
                (systemConnectors==null?0:systemConnectors.length);
                
	    String [] choices = new String[numAdapters];
            int i = 0;
	    if(dropDownObjectName != null) {
		for(;i < dropDownObjectName.length; i++) {
		    //hardcoding the name for now, may be we should get this from the xml file.
		    String dropDownChoice = (String)
                        MBeanUtil.getAttribute(dropDownObjectName[i], "name");
		    choices[i] = dropDownChoice;
                    //System.out.println("dropDownObjectName=" +dropDownObjectName[i].toString() + " name=" + dropDownChoice);
		}
	    }
	    if (embeddedConnectors != null) {
		for(int j = 0; j < embeddedConnectors.length; j++, i++) {
		    choices[i] = embeddedConnectors[j];
                    //System.out.println("embeddedConnectors= "+ embeddedConnectors[j]);
		}
            }
            if (systemConnectors != null) {
		for(int j = 0; j < systemConnectors.length; j++, i++) {
		    choices[i] = systemConnectors[j];
                    //System.out.println("systemConnectors= "+ systemConnectors[j]);
		}
            }
	    OptionList dropDownMenuOptions = new OptionList(choices,choices); // label and values
	    dropDownChild.setOptions(dropDownMenuOptions);
	} catch (Exception ex) {
	    throw new FrameworkException(ex, cvd, handlerCtx.getView());
	}
    }
    
    //This method will populate with the ALL (started,stopped) server instance, including those in cluster.
    //unless onlyRunningServer is set to true;
    public void populateServerInstances(RequestContext ctx, HandlerContext handlerCtx) {
        // the child should be something like: com.sun.web.ui.view.html.CCDropDownMenu
        SelectableGroup dropDownChild = (SelectableGroup) handlerCtx.getView();
        // get the parent container of the dropdown
        DescriptorContainerView parent = (DescriptorContainerView) dropDownChild.getParent();
        
        // need the child descriptor to get a parameter, retrieve from the parent descriptor.
        ViewDescriptor vd = parent.getViewDescriptor();
        ViewDescriptor cvd = vd.getChildDescriptor(dropDownChild.getName());
        boolean isEE = ConfigProperties.getInstance().getTargetSupported().booleanValue();
        Boolean onlyRunningServer = (Boolean) handlerCtx.getInputValue("onlyRunningServer");
	try {
            ArrayList results = new ArrayList();
            if (isEE){
                results.add("");
                results.add("server");
                Object unclustered = MBeanUtil.invoke("com.sun.appserv:type=servers,category=config",
                "listUnclusteredServerInstances", null, null);
                addToString(results, unclustered, onlyRunningServer);
                ObjectName[] clusters =
                (ObjectName[]) MBeanUtil.invoke("com.sun.appserv:type=clusters,category=config",
                "getCluster", null, null);
                if (clusters != null){
                    for(int i=0; i< clusters.length; i++){
                        String clusterName = (String)MBeanUtil.getAttribute(clusters[i], "name");
                        String objectName= "com.sun.appserv:type=cluster,name=" + 
                            clusterName + ",category=config";
                        Object clustered = MBeanUtil.invoke(objectName, 
                            "listServerInstances", null,null);
                        addToString(results, clustered, onlyRunningServer);
                    }
                }
            }else{
                results.add("server");
            }
	    
            String[] choices = new String[results.size()];
            for(int i=0; i< results.size(); i++){
                choices[i] = (String) results.get(i);
            }
            
	    OptionList dropDownMenuOptions = new OptionList(choices,choices); // label and values
	    dropDownChild.setOptions(dropDownMenuOptions);
	} catch (Exception ex) {
	    throw new FrameworkException(ex, cvd, handlerCtx.getView());
	}
    }
    
    
     public void setDropDownOptions(RequestContext ctx, HandlerContext handlerCtx) {
        // the child should be something like: com.sun.web.ui.view.html.CCDropDownMenu
        SelectableGroup dropDownChild = (SelectableGroup)handlerCtx.getInputValue(DISPLAY_FIELD);
        Object names = handlerCtx.getInputValue("names");
        Object labels = handlerCtx.getInputValue("labels");
        if (names instanceof String[]){
            OptionList dropDownMenuOptions = new OptionList((String[]) labels,(String[]) names); // label and values
            dropDownChild.setOptions(dropDownMenuOptions);
        }else
        if (names instanceof ArrayList){ 
            ArrayList nm = (ArrayList)names;
            ArrayList lb = (ArrayList)labels;
            
            OptionList dropDownMenuOptions = new OptionList(
                    (String[]) nm.toArray(new String[ nm.size()]),
                    (String[]) lb.toArray(new String[lb.size()]));
            
            dropDownChild.setOptions(dropDownMenuOptions);
        }else{
            throw new FrameworkException("setDropDownOptions() expects String[] or ArrayList for parameter names and labels");
        }
     }
     
     
     /*
      * Populate a selectable list, with multiple selections, the selected value
      * will either be the initialValue or obtained  by getting the attribute of the 
      * object.
      */
     public void populateList(RequestContext ctx, HandlerContext handlerCtx) {
         
         //Fill the selected list first
         SelectableGroup dropDownChild = (SelectableGroup) getSelectableGroup(handlerCtx);
         populateDropDown(handlerCtx, dropDownChild);
         //initialValue should be a comma seperated list
         String initialValue   = (String)handlerCtx.getInputValue("initialValue");
         dropDownChild.setLabelForNoneSelected("    ");
         if (initialValue == null){
            String attributeName = (String)handlerCtx.getInputValue("selectAttribute");
            String objectName   = (String)handlerCtx.getInputValue("selectObjectName");
            initialValue = (String) MBeanUtil.getAttribute(objectName, attributeName);
         }
         
         if (initialValue != null){
             String[] eachRow = initialValue.split(",");
             if (eachRow != null & eachRow.length > 0){
                 dropDownChild.setValues(eachRow);
             }
	}
     }
     
     public void setDropDownOptionsAndDefaultValue(RequestContext ctx, HandlerContext handlerCtx) {
        // the child should be something like: com.sun.web.ui.view.html.CCDropDownMenu
        SelectableGroup dropDownChild = (SelectableGroup)handlerCtx.getInputValue(DISPLAY_FIELD);
        String[] names = (String[]) handlerCtx.getInputValue("names");
        String[] labels = (String[]) handlerCtx.getInputValue("labels");
        OptionList dropDownMenuOptions = new OptionList(labels,names); // label and values
        dropDownChild.setOptions(dropDownMenuOptions);
        if( (names!=null) && names.length > 0)
            dropDownChild.setValue(names[0]);
     }
     
     public void isInArray(RequestContext ctx, HandlerContext handlerCtx) {
        String s = (String)handlerCtx.getInputValue("string");
        String[] array = (String[]) handlerCtx.getInputValue("array");
        Boolean isInArray = Boolean.FALSE;
            for (int i=0; i< array.length; i++) {
                if (s.equals(array[i])) {
                    isInArray = Boolean.TRUE;
                    break;
                }
            }
        handlerCtx.setOutputValue("isInArray", isInArray);
     }
    
    private void addToString(ArrayList result, Object obj, Boolean onlyRunningServer)
    {
        boolean includeAll = true;
        if (obj == null)
            return;
        if ((onlyRunningServer != null) && onlyRunningServer.booleanValue())
            includeAll = false;
        if (obj instanceof String[]){
            String[] ss = (String[]) obj;
            for(int i=0; i< ss.length; i++){
                if (includeAll)
                    result.add(ss[i]);
                else{
                    if (LogViewerHandler.isServerRunning(ss[i]))
                        result.add(ss[i]);
                }
            }
        }else
        if (obj instanceof ObjectName[]){
            ObjectName[]  oo = (ObjectName[])obj;
            for(int i =0; i < oo.length; i++) {
                String nm = (String)MBeanUtil.getAttribute(oo[i], "name");
                if (includeAll)
                    result.add(nm);
                else{
                    if (LogViewerHandler.isServerRunning(nm))
                        result.add(nm);
                }
            }
        }
    }
        

    /**
     *	This method logs the user out of the admingui.  This is accomplished
     *	by invalidating the user's session, marking the response started, and
     *	forwarding (via the RequestDispatcher) to the next page.  The
     *	RequestDispatcher is used b/c, we cannot forward the standard way
     *	after invalidating the session.  The markResponseStarted() method is
     *	necessary because we can't foward the standard way.
     */
    public void logout(RequestContext ctx, HandlerContext handlerCtx) {
        ctx.getRequest().getSession().removeAttribute("AdminGUItimeOut");
	ctx.getRequest().getSession().invalidate();
	RequestContextImpl.markResponseStarted(ctx);
	try {
	    ctx.getServletContext().getRequestDispatcher(ENTRY_URI).
		forward(ctx.getRequest(), ctx.getResponse());
	} catch (ServletException ex) {
	    throw new FrameworkException(ex, null, handlerCtx.getView());
	} catch (IOException ex) {
	    throw new FrameworkException(ex, null, handlerCtx.getView());
	}
    }

    public void handleTabHrefRequest(RequestContext ctx, HandlerContext handlerCtx) {
	View view = handlerCtx.getView();
        View tabset = view.getParent(); // the view is the href
        ViewBean vb = (ViewBean)tabset.getParent();
        
        try {
            DescriptorCCTabs tabs = (DescriptorCCTabs)vb.getChild(tabset.getName());
            
            // make a new event type
            ViewCommandEvent ev = (ViewCommandEvent)handlerCtx.getEvent();
            RequestInvocationEvent reqEvent = 
                new ViewRequestInvocationEvent(ev.getSource(), ctx, 
		   ev.getInvocation());
            tabs.handleTabHrefRequest(reqEvent);
        } catch (Exception ex) {
	    throw new FrameworkException(ex, null, view);
        }
    }
    
    
    public void beginDropDownDisplay(RequestContext ctx, HandlerContext handlerCtx) {
        CCDropDownMenuTag tag = (CCDropDownMenuTag)handlerCtx.getEvent().getSource();
        tag.setOnChange("javascript: loadRightSide();");
    }
    
    static public void setTimeOut(RequestContext rc) {
        // called by the AdminGUIServlet
        String timeOut = null;
        try {
            timeOut = (String)MBeanUtil.getAttribute(
                "ias:type=das-config,config=server-config,category=config", 
                "admin-session-timeout-in-minutes");
        } catch (Exception ex) {
	    throw new FrameworkException(
		"Exception throw in trying to get '"+
		"admin_session_timeout_in_minutes'", ex);
        }
        if ((timeOut != null) && !timeOut.equals("")) {
            try {
                int time = new Integer(timeOut).intValue();
                HttpServletRequest req = rc.getRequest();
                if (time == 0) {
                    req.getSession().setMaxInactiveInterval(-1);
		} else {
                    req.getSession().setMaxInactiveInterval(time*60);
		}
		if (Util.isLoggableFINE()) {
		    Util.logFINE("Setting session time out to "+timeOut+" minutes.");
		}
            } catch (NumberFormatException ex) {
		throw new FrameworkException(
		    "Unable to convert '"+timeOut+"'!", ex);
            }
        }
    }


    /**
     *
     */
    public void showTimeOut(RequestContext ctx, HandlerContext handlerCtx) throws Exception {
	View view = handlerCtx.getView();
        String timeOut = (String)((CCTextField)view).getValue();
        if (timeOut == null || timeOut.equals("")) {
            HttpServletRequest req = ctx.getRequest();
            int time = req.getSession().getMaxInactiveInterval();
            if (time <= 0)
                ((CCTextField)view).setValue("0");
            else
                ((CCTextField)view).setValue(""+(time/60));
        }
    }

    public void setFullTableName(RequestContext ctx, HandlerContext handlerCtx) {
	View view = handlerCtx.getView();
	DescriptorContainerView descView = (DescriptorContainerView)
	    (((ViewBase)view).getParentViewBean());
	//ViewDescriptor vd = descView.getViewDescriptor();
        
	String childName = (String)handlerCtx.getInputValue("propertiesTableName");
        if (childName == null || childName.length() == 0) {
	    return;
	}
        childName = descView.getName() + "." + childName;
        ((DisplayField)view).setValue(childName);        
    }

    public void addValueToPropertiesList(RequestContext ctx, HandlerContext handlerCtx) {
	Map props = (Map)handlerCtx.getInputValue("Properties");
        if (props == null || props.size() == 0) {
	    return;
	}
	String value = (String)handlerCtx.getInputValue("propertyValue");
	String key = (String)handlerCtx.getInputValue("propertyName");
	props.put(key, value);
	handlerCtx.setOutputValue(VALUE, props);
	handlerCtx.setOutputValue("props", new Properties());
    }

    public void getXMLFileFromClasspath(RequestContext ctx, HandlerContext handlerCtx) {
	String fileName = (String)handlerCtx.getInputValue("fileName");
        if (fileName == null || fileName.length() == 0) {
	    return;
	}
	InputStream is = getClass().getClassLoader().getResourceAsStream(fileName);
	handlerCtx.setOutputValue(VALUE, is);
    }
    
    /**
     *
     */
    public void deleteChildView(RequestContext ctx, HandlerContext handlerCtx) {
    	// Get the ServletRequest
	ServletRequest req = ctx.getRequest();

	// Get the parameters
	ContainerViewBase base = (ContainerViewBase)handlerCtx.getInputValue("container");
	String childName = (String)handlerCtx.getInputValue("child");
	if ((base == null) || (childName == null)) {
	    throw new FrameworkException(
		"'view' and/or 'child' attributes were null!", null, handlerCtx.getView());
	}
	boolean clearModel =
	    new Boolean(""+handlerCtx.getInputValue("clearModel")).booleanValue();

	// Optionally clear the Model
	if (clearModel) {
	    Model model = (Model)handlerCtx.getInputValue("model");
	    if (model == null) {
		View child = base.getChild(childName);
		if (child instanceof ContainerView) {
		    model = ((ContainerView)child).getDefaultModel();
		} else if (child instanceof DisplayFieldImpl) {
		    model = ((DisplayFieldImpl)child).getModel();
		}
	    }
	    if ((model != null) && (model instanceof DefaultModel)) {
		((DefaultModel)model).clear();
	    }
	}

	base.removeChild(childName);
    }



    /**
     *	This method iterates over an array of Model names.  For each model
     *	name, it clears the Model (in the case of DefaultModels) and checks
     *	to see if the model exists in Session.  If it does exist in Session,
     *	it will be removed from session.  This method expects MODEL_NAMES
     *	("modelNames") to be a request Attribute specifying the Model names
     *	to remove.
     */
    public void clearModels(RequestContext ctx, HandlerContext handlerCtx) {
	Object obj = handlerCtx.getInputValue(MODEL_NAMES);
	if (obj == null) {
	    throw new FrameworkException(
		"You must specifiy 'models' to remove from Session.");
	}
	if (obj instanceof String) {
	    ArrayList list = new ArrayList();
	    list.add(obj);
	    obj = list;
	}
	if (!(obj instanceof List)) {
	    throw new FrameworkException(
		"'"+MODEL_NAMES+"' must be a java.util.List!");
	}
	String names[] =
	    (String [])((List)obj).toArray(new String[((List)obj).size()]);

	// Check and remove each model as necessary.
	HttpServletRequest req = ctx.getRequest();
	HttpSession session = req.getSession();
	ModelManager modelMgr = ctx.getModelManager();
	Model model = null;
	for (int count=0; count<names.length; count++) {
	    obj = session.getAttribute(names[count]);
	    if (obj != null) {
		model = (Model)obj;
		if (model instanceof DefaultModel) {
		    // First clear() the model b/c the model on the next
		    // page will still be in memory and needs to be reset.
		    ((DefaultModel)model).clear();
		}
		modelMgr.removeFromSession(model);
	    }
	}
    }

    
    /**
     *
     */
    public void dumpMBeanNames(RequestContext ctx, HandlerContext handlerCtx) {
        try {
            javax.management.MBeanServerConnection server = MBeanUtil.getMBeanServer();
            java.util.Iterator it = server.queryNames(null, null).iterator();
            StringBuffer buf = new StringBuffer();
            buf.append("   MBean Object Names:\n");
            buf.append("======================\n");
            while (it.hasNext()) {
                buf.append(" * "+it.next().toString());
            }
            {
                Util.logCONFIG(buf.toString());
            }
        } catch (Exception ex) {
            // ignore.
        }
    }

    public void parseFilterOptions(RequestContext ctx, HandlerContext handlerCtx) {
	View view = handlerCtx.getView();
        
        String value = (String)handlerCtx.getInputValue("value");
        if (value != null) {
            String[] values = value.split(";");
            handlerCtx.setOutputValue("methodName", values[0]);
            if (values.length > 1) {
                handlerCtx.setOutputValue("editPage", values[1]);
            }
            //System.out.println("values : " + values[0] + "," + values[1]);
        }
    }

    /**
     *	This method clears the ViewDescriptor cache so that changes in that
     *	file can be re-read.
     */
    public void clearCache(RequestContext ctx, HandlerContext handlerCtx) {
	ViewDescriptorManager.getInstance().clearCache();
    }

    public void dumpStack(RequestContext ctx, HandlerContext handlerCtx) {
        Thread.currentThread().dumpStack();
    }
     
    /**
     *	This method dumps very detailed MBeanInfo about ALL Mbeans.
     */
    public void dumpMBeanInfo(RequestContext ctx, HandlerContext handlerCtx) {
	String output = null;
        try {
            javax.management.MBeanServerConnection server = MBeanUtil.getMBeanServer();
            java.util.Iterator it = server.queryNames(null, null).iterator();
            StringBuffer buf = new StringBuffer();
            buf.append("\n              MBean Object Info:");
            buf.append("================================");
            ObjectName name;
            javax.management.MBeanInfo info;
            javax.management.MBeanOperationInfo opInfo[];
            javax.management.MBeanParameterInfo paramInfo[];
            javax.management.MBeanAttributeInfo attInfo[];
            javax.management.MBeanNotificationInfo noteInfo[];
            while (it.hasNext()) {
                buf.append("----------------------------\n");
                name = (ObjectName)it.next();
                buf.append("  OBJECT NAME: "+name.toString()+"\n");
                try {
                    info = server.getMBeanInfo(name);
                } catch (Exception ex) {
                    throw new FrameworkException(
                        "Can't get the MBeanInfo!", ex, null, handlerCtx.getView());
                }
                buf.append("   CLASS NAME: "+info.getClassName()+"\n");
                buf.append("  DESCRIPTION: "+info.getDescription()+"\n");
                // Operations
                buf.append("   OPERATIONS:\n");
                opInfo = info.getOperations();
                for (int count=0; count<opInfo.length; count++) {
                    if (opInfo[count] == null) {
                        buf.append("    WARNING: opInfo["+count+"] is null!\n");
                        continue;
                    }
                    buf.append("\t* "+opInfo[count].getReturnType()+" "+opInfo[count].getName()+"(");
                    paramInfo = opInfo[count].getSignature();
                    for (int idx=0; idx<paramInfo.length; idx++) {
                        buf.append(paramInfo[idx].getType())
                            .append(" ")
                            .append(paramInfo[idx].getName())
                            .append(" - ")
                            .append(paramInfo[idx].getDescription());
                        if (idx<paramInfo.length-1) {
                            buf.append(", ");
                        }
                    }
                    buf.append(") - "+opInfo[count].getImpact()+"\n");
                    if (opInfo[count].getDescription() != null)
                        buf.append("\t    Desc: "+opInfo[count].getDescription()+"\n\n");
                }
                // Attributes
                buf.append("   Attributes:\n");
                attInfo = info.getAttributes();
                for (int count=0; count<attInfo.length; count++) {
                    buf.append("\t* "+attInfo[count].getType()+" "+attInfo[count].getName());
                    if (attInfo[count].isIs()) {
                        buf.append(" - HAS 'is' GETTER");
                    }
                    if (!attInfo[count].isReadable()) {
                        buf.append(" - NOT READABLE");
                    }
                    if (!attInfo[count].isWritable()) {
                        buf.append(" - NOT WRITABLE");
                    }
                    if (attInfo[count].getDescription() != null)
                        buf.append("\n\t    Desc: "+attInfo[count].getDescription()+"\n");
                }
                // Notifications
                noteInfo = info.getNotifications();
                if (noteInfo.length > 0) {
                    buf.append("   Notifications:\n");
                    for (int count=0; count<noteInfo.length; count++) {
                        buf.append("\t")
                            .append(noteInfo[count].getName())
                            .append(" - ")
                            .append(noteInfo[count].getDescription()+"\n");
                        String types[] = noteInfo[count].getNotifTypes();
                        buf.append("\t    Notification Types: ");
                        for (int idx=0; idx<types.length; idx++) {
                            buf.append("\t\t"+types[idx]+"\n");
                        }
                        buf.append("\n");
                    }
                }
                buf.append("\n");
            }
            buf.append("======================\n");
	    output = buf.toString();
            {
                Util.logCONFIG(output);
            }
        } catch (Exception ex) {
            // ignore 
        }
	handlerCtx.setOutputValue(VALUE, output);
    }


    /**
     *	This handler is designed for Error Handlers only.  It checks the given 
     *	exception to see if any MBean exceptions are present.  If one is, then
     *	the message is pulled off and stored in request attribute
     *	"MBEAN_MESSAGE".  If one is not found, the lowest non-null message is
     *	set in the "MBEAN_MESSAGE" attribute.  "HAS_MBEAN_MESSAGE" is always
     *	set to true, "ALERT_TYPE" is always set to "error", and "ALERT_SUMMARY"
     *	is set to "alert.Summary".
     */
    public void mbeanExceptionCheck(RequestContext ctx, HandlerContext handlerCtx) {
	if (!(handlerCtx.getEvent() instanceof ErrorEvent)) {
	    throw new FrameworkException(
		"This method is meant only for ErrorEvent types.  This "+
		"handler will attempt to find a message from the "+
		"ErrorEvent's Exception", null, handlerCtx.getView());
	}

	// Look for an MBeanException
	Throwable ex = ((ErrorEvent)handlerCtx.getEvent()).getException();
	if (ex == null) {
	    throw new FrameworkException(
		"Exception is null, this is illegal!", null, handlerCtx.getView());
	}
	Throwable last = ex;
	String message = null;
	String val = ex.getLocalizedMessage();
	if (val == null) {
	    val = ex.getMessage();
	}
	if (val != null) {
	    message = val;
	}
	boolean foundMBean = false;
        boolean foundAMX = false;
	while (ex != null) {
	    // Get the next exception
	    if (ex instanceof RootCauseException) {
		ex = ((RootCauseException)ex).getRootCause();
	    } else {
		if (ex instanceof MBeanException) {
		    // Flag to stop as soon as we have a message
		    foundMBean = true;
		} else if (ex instanceof UndeclaredThrowableException) {
                    foundAMX = true;
                }
                if (foundAMX) {
                    ex = ExceptionUtil.getRootCause(ex);
                } else {
                    ex = ex.getCause();
                }
	    }

	    // Try to get the message
	    if (ex != null) {
		last = ex;
		val = ex.getLocalizedMessage();
		if (val == null) {
		    val = ex.getMessage();
		}
		if (val != null) {
		    message = val;
		    if ((ex instanceof MBeanException) || foundMBean || foundAMX) {
			break;
		    }
		}
	    }
	}

	// Pull off the message as best we can
	ServletRequest req = ctx.getRequest();
	handlerCtx.setOutputValue(MBEAN_MESSAGE,
	    (message == null) ? "error.NullMessage" : message);
	handlerCtx.setOutputValue(HAS_MBEAN_MESSAGE, TRUE);
	handlerCtx.setOutputValue(HAS_ERROR_MESSAGE, TRUE);
	handlerCtx.setOutputValue(ALERT_TYPE, "error");
	handlerCtx.setOutputValue(ALERT_SUMMARY, "alert.Summary");
    }


    /**
     *	Exception Log Handler -- This handler logs an exception to the LogFile.
     */
    public void logException(RequestContext ctx, HandlerContext handlerCtx) {
	if (!Util.isLoggableINFO()) {
	    return;
	}
	ServletRequest req = ctx.getRequest();
	Throwable ex = (Throwable)handlerCtx.getInputValue(EXCEPTION_TO_LOG);
	String level = (String)handlerCtx.getInputValue(LEVEL);
        if (level == null)
            level = "FINE";
	if (ex != null) {
            if (level.equalsIgnoreCase("FINEST"))
                Util.logFINEST(ex);
            else if (level.equalsIgnoreCase("FINER"))
                Util.logFINER(ex);
            else if (level.equalsIgnoreCase("FINE"))
                Util.logFINE(ex);
            else if (level.equalsIgnoreCase("CONFIG"))
                Util.logCONFIG(ex);
            else if (level.equalsIgnoreCase("INFO"))
                Util.logINFO(ex);
            else if (level.equalsIgnoreCase("WARNING"))
                Util.logWARNING(ex);
            else if (level.equalsIgnoreCase("SEVERE"))
                Util.logSEVERE(ex);
	} else {
	    Util.logFINE(getClass().getName()+
		".logException() called without an exception to log.");
	}
    }

    /**
     *	<P> This method determines if the input value X is greater than the
     *	    input value Y.  Both input values are expected to be Integers,
     *	    the result will be stored in "result" and will be a Boolean.</P>
     *
     *	<P> This method expects the following input parameters:</P>
     *
     *	<UL><LI>X	--	Long	--  The integer X to evaluate
     *	    <LI>Y	--	Long	--  The integer Y to evaluate</LI></UL>
     *
     *	<P> It returns the following output parameters:</P>
     *
     *	<UL><LI>value	--	Boolean	--  Result of: X&gt;Y</LI></UL>
     *
     *	@param	ctx	    The RequestContext
     *	@param	handlerCtx  The HandlerContext
     */
    public void isXGreaterThanY(RequestContext ctx, HandlerContext handlerCtx) {
	// Get the input values
	Long long1 = (Long)handlerCtx.getInputValue("X");
	Long long2 = (Long)handlerCtx.getInputValue("Y");
	if ((long1 == null) || (long2 == null)) {
	    throw new FrameworkException(getClass().getName()+
		".isXGreaterThanY() requires both 'X' and 'Y' as request "+
		"attributes.", null, handlerCtx.getView());
	}

	// Perform the check...
	Boolean result = new Boolean(long1.longValue()>long2.longValue());

	// Set the result
	handlerCtx.setOutputValue(VALUE, result);
    }

    /**
     *	This method adds two long integers together.  The 2 longs should be
     *	stored in "long1" and "long2".  The result will be stored as "result".
     */
    public void longAdd(RequestContext ctx, HandlerContext handlerCtx) {
    	// Get the inputs
	Long long1 = (Long)handlerCtx.getInputValue(LONG_INTEGER_1);
	Long long2 = (Long)handlerCtx.getInputValue(LONG_INTEGER_2);
	if ((long1 == null) || (long2 == null)) {
	    throw new FrameworkException(getClass().getName()+
		".longAdd() requires that both '"+LONG_INTEGER_1+"' and '"+
		LONG_INTEGER_2+"' be supplied as request attributes.",
		null, handlerCtx.getView());
	}

	// Add the 2 numbers together
	Long result = new Long(long1.longValue()+long2.longValue());

	// Set the result
	handlerCtx.setOutputValue(LONG_ADD_RESULT, result);
    }


    /**
     *	<p> This method sleeps for a second.</p>
     */
    public void sleep(RequestContext ctx, HandlerContext handlerCtx) {
	try {
	    Thread.currentThread().sleep(1*1000);
	} catch (Exception ex) {
	    ex.printStackTrace();
	}
    }

    /**
     *	This handler throws a RuntimeException for testing purposes.  This
     *	allows you to put this handler anywhere to test how an exception will
     *	be handled.
     */
    public void throwException(RequestContext ctx, HandlerContext handlerCtx) {
	throw new RuntimeException("Throwing an exception for testing "+
	    "purposes.  The view name given to this handler is: '"+
	    handlerCtx.getView().getName()+"'.  The EventObject is: '"+handlerCtx.getEvent()+
	    "'.  The event.getSource() is: '"+handlerCtx.getEvent().getSource()+"'.");
    }

    /**
     *	This handler returns TRUE if the test object is null or have no element.  
     */
    public Boolean returnTrueIfEmpty(RequestContext ctx, HandlerContext handlerCtx) {
        Object value = handlerCtx.getInputValue("value");
        if (value == null)
            return TRUE;
        if (value instanceof String)
            return ( Util.isEmpty((String) value)) ? TRUE: FALSE;
        if (value instanceof Object[])
        {   int size = ((Object[])value).length;
            //System.out.println("returnFalseIfEmpty: is instanceof Object[] " + size);
            return (((Object[])value).length == 0) ? TRUE: FALSE;
        }
        return FALSE;
    }

    /**
     *	This handler returns false.  If you want a beginDisplay event to
     *	return false.
     */
    public Boolean returnFalse(RequestContext ctx, HandlerContext handlerCtx) {
	return FALSE;
    }


    /**
     *	This handler returns true.  This is useful if you want a beginDisplay
     *	event to return true.
     */
    public Boolean returnTrue(RequestContext ctx, HandlerContext handlerCtx) {
	return TRUE;
    }
    
    public void setExtraValuesMapInCommandField(RequestContext ctx, HandlerContext handlerCtx) {
        CommandFieldBase commandField =  (CommandFieldBase)handlerCtx.getView();
        HashMap m = new HashMap();
        m.put((String)handlerCtx.getInputValue(NAME), 
            handlerCtx.getInputValue("value"));
        commandField.setExtraValuesMap(m);
    }
    
    
    public void addExtraValueInCommandField(RequestContext ctx, HandlerContext handlerCtx) {
        CommandFieldBase commandField =  (CommandFieldBase)handlerCtx.getView();
	String name = ((String)handlerCtx.getInputValue(NAME));
	String value = ((String)handlerCtx.getInputValue(VALUE));
        commandField.addExtraValue(name, value);
    }
    
    /**
     *	This handler returns true if key1 = key2.  
     */
    public void isEqual(RequestContext ctx, HandlerContext handlerCtx) {
        Object key1 = handlerCtx.getInputValue("key1");
        Object key2 = handlerCtx.getInputValue("key2");
        Boolean result = FALSE;
        if (key1 != null && key2 != null) {
            result = new Boolean(key1.equals(key2));
        }
        handlerCtx.setOutputValue("value", result);
    }
    
    /**
     *	This handler returns true if key1 = key2 (ignore case).  
     */
    public void isEqualsIgnoreCase(RequestContext ctx, HandlerContext handlerCtx) {
        String key1 = (String) handlerCtx.getInputValue("key1");
        String key2 = (String) handlerCtx.getInputValue("key2");
        Boolean result = FALSE;
        if (key1 != null && key2 != null) {
            result = new Boolean(key1.equalsIgnoreCase(key2));
        }
        handlerCtx.setOutputValue("value", result);
    }

    // returns null if object is 'empty' - for Strings this means, strings with wghite
    // spaces only
    public void  getNullIfEmpty(RequestContext ctx, HandlerContext handlerCtx) {
        Object obj = handlerCtx.getInputValue(VALUE);
        if (obj != null && obj instanceof String) {
            String str = (String) obj;
            if (str.trim().length() == 0) {
                obj = null;
            }
        }
	handlerCtx.setOutputValue(VALUE, obj);
    }
    
    public void isValidMbean(RequestContext ctx, HandlerContext handlerCtx) {
        String objectName = (String)handlerCtx.getInputValue("mbeanName");
        boolean valid = MBeanUtil.isValidMBean(objectName);
	handlerCtx.setOutputValue("isValid", new Boolean(valid));
    }
    
    public void convertStartEndDate(RequestContext ctx, HandlerContext handlerCtx) {
        String strStartDate = (String)handlerCtx.getInputValue("strStartDate");
        String strEndDate = (String)handlerCtx.getInputValue("strEndDate");
        DateFormat df = DateFormat.getDateInstance(DateFormat.SHORT);
        Date startDate = null;
        Date endDate = null;
        if (!Util.isEmpty(strStartDate)) {
            try {
                startDate = df.parse(strStartDate);
            } catch (java.text.ParseException pe) {
                throw new FrameworkException(Util.getMessage("msg.InvalidStartDateError", new Object[]{strStartDate}));
            }
        }
        if(!Util.isEmpty(strEndDate)) {
            try {
                endDate = df.parse(strEndDate);
            } catch (java.text.ParseException pe) {
                throw new FrameworkException(Util.getMessage("msg.InvalidEndDateError", new Object[]{strEndDate}));
            }
        }
        if (startDate != null && endDate != null) {
            if (startDate.after(endDate)) {
                throw new FrameworkException(Util.getMessage("msg.StartDateAfterEndDateError"));
            }
        }
        if (!Util.isEmpty(strStartDate) && Util.isEmpty(strEndDate)) {
            throw new FrameworkException(Util.getMessage("msg.MissingEndDateError"));
        } else if (Util.isEmpty(strStartDate) && !Util.isEmpty(strEndDate)) {
            throw new FrameworkException(Util.getMessage("msg.MissingStartDateError"));
        }
        
        handlerCtx.setOutputValue("startDate", startDate);
        handlerCtx.setOutputValue("endDate", endDate);
    }
    
    public void returnMap(RequestContext ctx, HandlerContext handlerCtx) {
        ArrayList keyList = (ArrayList)handlerCtx.getInputValue("keyList");
        ArrayList valueList = (ArrayList)handlerCtx.getInputValue("valueList");
        HashMap map = new HashMap();
        for (int i=0; i < keyList.size(); i++) {
            map.put(keyList.get(i),  valueList.get(i));
        }
        handlerCtx.setOutputValue("map", map);
    }
    
    private Object[] getNodeAgentsAsDropDown( String methodName, 
        String objectName, ArrayList params, ArrayList types) 
    {
        Object[] paramsAndTypes = MBeanUtil.getParamsAndTypes(params, types);
	try {
            Object objs = MBeanUtil.invoke(objectName, methodName, 
                (Object[])(paramsAndTypes[0]), (String[])(paramsAndTypes[1]));
            if (objs != null && objs instanceof ObjectName[]) {
                ObjectName[] naObjectNames = (ObjectName[])objs;

                String[] naNames = new String[naObjectNames.length];
                String[] labels = new String[naObjectNames.length];
                for(int i =0; i < naObjectNames.length; i++) {
                    String naName = (String)MBeanUtil.getAttribute(naObjectNames[i], "name");
                    String label = naName + 
                        "  ("+getHostOfNodeAgent(naObjectNames[i].toString())+")";
                    naNames[i]= naName;
                    labels[i] = label;
                }
                return new Object[]{naNames, labels};
            }
            return new Object[]{new String[]{""}, new String[]{""}};
        } catch (Exception ex) {
	    throw new FrameworkException(ex);
	}
    }
    
    private String getHostOfNodeAgent(String naObjectName) {
        
        String hostName = Util.getMessage("nodeAgent.UnknownHost");
        try {
            String[] types = new String[]{"java.lang.String"};
            Object[] params = new Object[]{"rendezvousOccurred"};
            String result = (String)MBeanUtil.invoke(
                naObjectName,
                "getPropertyValue", params, types);
            if (result.equalsIgnoreCase("false")) {
                return hostName;
            }
        } catch (Exception ex) {
            //System.out.println("=============== Exception in getHostOfNodeAgent  =============  \n" + ex);
            //ex.printStackTrace(System.out);
        }
        try {
            ObjectName jmxConnector = (ObjectName)MBeanUtil.invoke(
                naObjectName, "getJmxConnector", null, null);
            if (jmxConnector != null ) {
                String[] types = new String[]{"java.lang.String"};
                Object[] params = new Object[]{"client-hostname"};
                hostName = (String)MBeanUtil.invoke(
                    jmxConnector,
                    "getPropertyValue", params, types);
            }
        }catch (Exception ex){
            //System.out.println("=============== Exception in getHostOfNodeAgent  =============  \n" + ex);
            //ex.printStackTrace(System.out);
        }
        return hostName;
    }
    
    public String getHostOfNodeAgent(RequestContext ctx, HandlerContext handlerCtx) {
        String naObjectName = (String)handlerCtx.getInputValue("nodeAgentObjectName");
        String hostName = getHostOfNodeAgent(naObjectName);
	handlerCtx.setOutputValue("hostName", hostName);
        return hostName;
    }
    
    public void displayPropertyChild(RequestContext ctx, HandlerContext handlerCtx) {
	ViewDescriptor vd;
        vd = handlerCtx.getViewDescriptor();
        
        if (vd instanceof CCPropertySheetDescriptor) {
            CCPropertySheetModelInterface model = 
                ((CCPropertySheetDescriptor)vd).getModel();
            String propertyName = (String)handlerCtx.getInputValue("propertyName");
	    Boolean displayValue = (Boolean)handlerCtx.getInputValue("value");
            if (propertyName != null) {
                model.setVisible(propertyName, displayValue.booleanValue());
            }
   
        } else {
            throw new RuntimeException("ViewDesc should be of type property sheet.");
        }
    }
    
    /** 
     * Displays the tile, and help messages for PageTitle.
     * Inputs should be the localized keys for title, and help messages.
     * @param ctx
     * @param handlerCtx
     */
    public void PageTitleDisplay(RequestContext ctx, HandlerContext handlerCtx) {
//    	 the child should be something like: com.sun.web.ui.view.html.CCPageTitleTag
        CCPageTitleTag tag = (CCPageTitleTag)handlerCtx.getEvent().getSource();
        String titleKey = (String)handlerCtx.getInputValue("titleKey");
        String helpKey = (String)handlerCtx.getInputValue("helpKey");
        ArrayList argList = (ArrayList)handlerCtx.getInputValue("args");
        Object[] args = null;
        if (argList != null && argList.size() > 0) {
            args = (Object[])argList.toArray(new Object[argList.size()]);
        }
        if(titleKey != null) {
            String titleText = null;
            if (args == null || args.length == 0) {
        	titleText = Util.getMessage(titleKey);
        	
            } else {
                titleText = Util.getMessage(titleKey, args);
            }
            tag.setPageTitleText(titleText);
        }
        
        if(helpKey != null) {
        	String helpText = Util.getMessage(helpKey);
        	tag.setPageTitleHelpMessage(helpText);
        }
        
    }

    //This fix is temporary to work around a bug in Jato/Lockhard which generate invalid html
    //when the function setExtraValuesMapInCommandField() is called inside the beginDisplay event
    //of a button.  
    public String temporaryFixHtmlError(RequestContext ctx, HandlerContext handlerCtx) {
    if (!(handlerCtx.getEvent() instanceof ChildContentDisplayEvent)) {
        //System.out.println(" !!!! temporaryFixHtmlError returns NULL");
	    return null;
	}
	String content = (String) ((ChildContentDisplayEvent)handlerCtx.getEvent()).getContent();
        String result = content.replaceFirst("\"<", "\"> <") ;
        String result1 = result.replaceFirst("/> */>", "/> </input> ") ;
        return result1;
    }

    /**
     *	<P> This method shortens the middle of the given string if it is longer
     *	    than the specified maxLength.</P>
     *
     *	<P> This method expects the following input parameters:</P>
     *
     *	<UL><LI>maxLength   --	Integer	--  Max String length before
     *		    truncating</LI>
     *	    <LI>headLength  --	Integer	--  Number of characters to leave at
     *		    the beginning of the string</LI>
     *	    <LI>tailLength  --	Integer	--  Number of characters to lave at
     *		    the end of the string</LI>
     *	    <LI>elipse	    --  String	--  The replacement string for the
     *		    truncated portion</LI>
     *	    <LI>string	    --	String	--  The String to shorten</LI></UL>
     *
     *	<P> It returns the following output parameters:</P>
     *
     *	<UL><LI>value	    --	String	--  The shortened string</LI></UL>
     *
     *	@param	ctx	    The RequestContext
     *	@param	handlerCtx  The HandlerContext
     */
    public void truncateMiddle(RequestContext ctx, HandlerContext handlerCtx) {
	// Get input values
        int maxLength   = ((Integer)handlerCtx.getInputValue(MAX_LENGTH)).intValue();
        int headLength   = ((Integer)handlerCtx.getInputValue(HEAD_LENGTH)).intValue();
        int tailLength   = ((Integer)handlerCtx.getInputValue(TAIL_LENGTH)).intValue();
        String elipse   = (String)handlerCtx.getInputValue(ELLIPSIS);
        String string   = (String)handlerCtx.getInputValue(STRING);
	if (string == null) {
	    string = "";
	}

	// Check to see if we should do anything
	if (string.length() > maxLength) {
	    // Shorten string
	    string = string.substring(0, headLength) +
		     elipse +
		     string.substring(string.length()-tailLength);
	}

	// Set the output value
	handlerCtx.setOutputValue(VALUE, string);
    }
     /**
     *	<P> This method returns the domain root. </P>
     *
     *	
     *	<P> It returns the following output parameters:</P>
     *
     *	<UL><LI>value	    --	String	--  DomainRoot directory for this Install.</LI></UL>
     *
     *	@param	ctx	    The RequestContext
     *	@param	handlerCtx  The HandlerContext
     */
    
    public String getDomainRoot(RequestContext ctx, HandlerContext handlerCtx) {
        String domainRoot = Util.getDomainRoot();
        handlerCtx.setOutputValue("domainRoot", domainRoot);
        return domainRoot;
    }
    
    /**
     *	<P> This method returns the endDisplay String as an output value.  It
     *	    optionally returns "" from the method (thereby skipping all output
     *	    to the actual stream).</P>
     *
     *	<P> This method expects the following input parameters:</P>
     *
     *	<UL><LI>returnEmptyString   --	Boolean	--  true to return "", false
     *		    to return the original HTML string</LI></UL>
     *
     *	<P> It returns the following output parameters:</P>
     *
     *	<UL><LI>value	    --	String	--  The html string</LI></UL>
     *
     *	@param	ctx	    The RequestContext
     *	@param	handlerCtx  The HandlerContext
     *
     *	@return	The original string or "" depending on "returnEmptyString"
     */
    public String getEndDisplayString(RequestContext ctx, HandlerContext handlerCtx) {
	if (!(handlerCtx.getEvent() instanceof ChildContentDisplayEvent)) {
	    throw new FrameworkException(getClass().getName()+
		".getEndDisplayString is only valid for endDisplay events!",
		null, handlerCtx.getView());
	}

	// Get the HTML String
	String value =
	    ((ChildContentDisplayEvent)handlerCtx.getEvent()).getContent();

	// Set the output value
	handlerCtx.setOutputValue(VALUE, value);

	// Get the input parameter
        boolean returnEmptyString = false;
	Object input = handlerCtx.getInputValue(RETURN_EMPTY_STRING);
	if (input != null) {
	    returnEmptyString = ((Boolean)input).booleanValue();
	}

	// Return the value
	return returnEmptyString ? "" : value;
    }

    /**
     *	<P> This method sets the "bound name" for the given DisplayField.
     *	    This method does not alter the associated Model.  This is useful
     *	    if the DisplayField name does not match the Model name.</P>
     *
     *	<P> This method expects the following input parameters:</P>
     *
     *	<UL><LI>displayField	--  DisplayField    --	The DisplayField</LI>
     *	    <LI>name		--  String	    --	The bound name</LI>
     *	</UL>
     *
     *	@param	ctx	    The RequestContext
     *	@param	handlerCtx  The HandlerContext
     */
    public void setBoundName(RequestContext ctx, HandlerContext handlerCtx) {
	// Get input values
	DisplayFieldImpl dispField =
	    (DisplayFieldImpl)handlerCtx.getInputValue(DISPLAY_FIELD);
	String name = (String)handlerCtx.getInputValue(NAME);
	if ((dispField == null) || (name == null) || name.equals("")) {
	    throw new FrameworkException("'"+DISPLAY_FIELD+"' and '"+NAME+
		"' are both required for setBoundName!", null,
		handlerCtx.getView());
	}

	// Set the bound name
	dispField.setBoundName(name);
    }

    /**
     *	<P> This method sets the "display label" for the given CCHref.
     *	    Setting the value of the CCHref has no (or little) effect
     *	    currently in LH.  The value is ignored when the JSP tag sets its
     *	    own "default value".  Futher since they set the value tag's
     *	    default value, containers that re-use Tags ALWAYS have the default
     *	    value set.  Using the "display label" is the only way to change
     *	    the value of a button on the fly.</P>
     *
     *	<P> This method expects the following input parameters:</P>
     *
     *	<UL><LI>cchref	--  DisplayField    --	The DisplayField</LI>
     *	    <LI>value	--  String	    --	The bound name</LI></UL>
     *
     *	@param	ctx	    The RequestContext
     *	@param	handlerCtx  The HandlerContext
     */
    public void setDisplayLabel(RequestContext ctx, HandlerContext handlerCtx) {
	// Get input values
	CCButton button = (CCButton)handlerCtx.getInputValue(CCBUTTON);
	String value = (String)handlerCtx.getInputValue(VALUE);
	if ((button == null) || (value == null)) {
	    throw new FrameworkException("'"+CCBUTTON+"' and '"+VALUE+
		"' are both required for setDisplayLabel!", null,
		handlerCtx.getView());
	}

	// Set the display label
	button.setDisplayLabel(value);
    }


    private static final String	ENTRY_URI	= "/admingui/TopFrameset";
    

    public static final Boolean FALSE	= new Boolean(false);
    public static final Boolean TRUE	= new Boolean(true);


    /**
     *	This attribute key should be set to one of the following: "error",
     *	"help", "info", "warning".
     */
    public static final String ALERT_TYPE	= "ALERT_TYPE";

    /**
     *
     */
    public static final String ALERT_SUMMARY	= "ALERT_SUMMARY";

    /**
     *	This attribute key is used to store a message from an MBeanException as
     *	a request attribute.  If an exception is thrown, but it is not an MBean
     *	Exception, then a the last message in the trace is used.
     *
     */
    public static final String MBEAN_MESSAGE	= "MBEAN_MESSAGE";
    public static final String HAS_MBEAN_MESSAGE= "HAS_MBEAN_MESSAGE";
    public static final String HAS_ERROR_MESSAGE= "HAS_ERROR_MESSAGE";

    public static final String NAME		= "name";
    public static final String VALUE		= "value";
    public static final String MODEL		= "model";
    public static final String MODEL_NAMES	= "modelNames";
    public static final String LONG_INTEGER_1	= "long1";
    public static final String LONG_INTEGER_2	= "long2";
    public static final String LONG_ADD_RESULT	= "result";
    public static final String EXCEPTION_TO_LOG	= "exceptionToLog";
    public static final String LEVEL		= "level";

    public static final String DISPLAY_FIELD	= "displayField";
    public static final String CCBUTTON		= "ccbutton";

    public static final String MAX_LENGTH	= "maxLength";
    public static final String HEAD_LENGTH	= "headLength";
    public static final String TAIL_LENGTH	= "tailLength";
    public static final String ELLIPSIS		= "ellipsis";
    public static final String STRING		= "string";

    public static final String RETURN_EMPTY_STRING  = "returnEmptyString";
    
}
