/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * TableHandlers.java
 *
 * Created on March 16, 2004, 3:13 PM
 */

package com.sun.enterprise.tools.admingui.handlers;

import java.util.ArrayList;
import java.util.Properties;
import java.util.Enumeration;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestContextImpl;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.ViewBeanManager;
import com.iplanet.jato.model.DefaultModel;
import com.iplanet.jato.model.Model;
import com.iplanet.jato.util.RootCauseException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBase;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.DisplayField;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.event.ChildContentDisplayEvent;
import com.iplanet.jato.util.NonSyncStringBuffer;

import javax.management.MBeanException;
import javax.management.ObjectName;
import javax.management.AttributeList;
import javax.management.Attribute;

import javax.servlet.ServletRequest;

import com.sun.enterprise.tools.guiframework.exception.FrameworkException;
import com.sun.enterprise.tools.guiframework.model.ModelManager;
import com.sun.enterprise.tools.guiframework.view.DescriptorContainerView;
import com.sun.enterprise.tools.guiframework.view.HandlerContext;
import com.sun.enterprise.tools.guiframework.view.ViewDescriptorManager;
import com.sun.enterprise.tools.guiframework.view.descriptors.ViewDescriptor;
import com.sun.enterprise.tools.guiframework.view.descriptors.CCActionTableDescriptor;
import com.sun.enterprise.tools.guiframework.view.event.BeforeCreateEvent;
import com.sun.enterprise.tools.guiframework.view.event.ErrorEvent;

import com.sun.web.ui.model.CCActionTableModelInterface;
import com.sun.web.ui.view.html.CCButton;
import com.sun.web.ui.taglib.pagetitle.CCPageTitleTag;
import com.sun.web.ui.taglib.html.CCTextFieldTag;

import com.sun.enterprise.tools.admingui.util.MBeanUtil;
import com.sun.enterprise.tools.admingui.util.Util;

import com.sun.enterprise.tools.admingui.ConfigProperties;


public class SystemPropsHandlers {
    
    static public String extractToken(String token) {
        if (token == null)
            return null;
        int j = token.indexOf("${");
        if (j >= 0) {
            int i = token.indexOf('}');
            if (i < 0) i = token.length();
            return token.substring(j+2,i);
        } 
        return token;
    }
    
    static public String resolveToken(String token) {
        String[] tokenTypes = new String[]{"java.lang.String", "java.lang.String"};
        Object[] tokensParams = new Object[]{"${"+token+"}", "server"};
        String value = (String) MBeanUtil.invoke(
            "com.sun.appserv:type=domain,category=config", "resolveTokens", 
            tokensParams, tokenTypes);
        return value;
    }
    
    static public String resolveAndReplaceToken(String tokenString) {
        String token = null;
        if (tokenString != null && tokenString.indexOf("${") >= 0)
            token = extractToken(tokenString);
        if (token == null)
            return tokenString;
        return tokenString.replaceAll("\\$\\{"+token+"\\}", resolveToken(token));
    }

    public void isConfigProperty(RequestContext ctx, HandlerContext handlerCtx) {
        String property = (String)handlerCtx.getInputValue("property");
        boolean result = false;
	//may be we've to check property.startsWith instead of indexOf. 
	//Leaving it for now, change this after HCF.
        if (property != null) 
            result = property.indexOf("com.sun.aas") >= 0;
	handlerCtx.setOutputValue("result", (result)?("true"):("false"));
    }

    public void loadConfigPropertyHelp(RequestContext ctx, HandlerContext handlerCtx) {
		CCActionTableModelInterface model = (CCActionTableModelInterface)
            handlerCtx.getInputValue(MODEL);
        ((DefaultModel)model).clear();
        String paramName = (String)handlerCtx.getInputValue("paramName");

        if (paramName == null) {
            return;
		}
		String baseName = "com.sun.enterprise.tools.admingui.resources.AsEnv";
		String description = Util.getMessage(baseName, paramName, null);
        model.appendRow();
        model.setValue("propertyName", paramName);
        model.setValue("description", description);
	}
    
    public void loadTokenEditTable(RequestContext ctx, HandlerContext handlerCtx) {
	CCActionTableModelInterface model = (CCActionTableModelInterface)
            handlerCtx.getInputValue(MODEL);
        ((DefaultModel)model).clear();

        String configObjectName = (String)handlerCtx.getInputValue("configName");
        String paramName = (String)handlerCtx.getInputValue("paramName");
        if (paramName == null)
            return;
        // remove the ${}
        paramName = extractToken(paramName);
        
        ObjectName[] refs = null;
        try {
            refs = (ObjectName[])MBeanUtil.invoke(configObjectName, 
                "listReferencees", null, null);
        } catch (Exception ex) {
            // This special case handling is for when the $-paramters are outside
            // a config and configName is not define, e.g. Domain attributes page.
            model.appendRow();
            model.setValue("clusterName", "");
            model.setValue("instanceName", "");
            model.setValue("value", resolveToken(paramName));
            //model.setValue("objectName", reference.toString()); // hidden variable 
            return;
        }
        loadSystemProperties(model, refs, paramName, "");
    }
    
    private void loadSystemProperties(CCActionTableModelInterface model, 
        ObjectName[] refs, String paramName, String clusterName) {
            
        if (refs == null)
            return;
        Object[] params = new Object[]{new Boolean(true)};
        String[] types  = new String[]{"boolean"};
        String[] tokenTypes = new String[]{"java.lang.String", "java.lang.String"};

        for (int i=0; i<refs.length; i++) {
            ObjectName reference = refs[i];
            //System.out.println("............target: "+reference);
            //String referenceStr = reference.toString().replaceAll("null", "com.sun.appserv");
            if (reference.getKeyProperty("type").equals("cluster")) {
                ObjectName[] instances = (ObjectName[]) MBeanUtil.invoke(reference,
                    "listServerInstances", null, null);
                clusterName = reference.getKeyProperty("name");
                loadSystemProperties(model, instances, paramName, clusterName);
                continue;
            }
            Properties props = (Properties)MBeanUtil.invoke(reference, 
                "listSystemProperties", params, types);
            //System.out.println("............ "+props);
            if (props == null) {
                continue;
            }
            String instanceName = reference.getKeyProperty("name");
            String value = props.getProperty(paramName, null);
            if (value == null) {
                // Value will be null if the property is a config property
                // instead of a system property.
                Object[] tokensParams = new Object[]{"${"+paramName+"}", instanceName};
                value = (String) MBeanUtil.invoke(
                    "com.sun.appserv:type=domain,category=config", "resolveTokens", 
                    tokensParams, tokenTypes);
            }
            if (value == null) value = "";
            //System.out.println("............ "+paramName+"="+value);
            model.appendRow();
            model.setValue("clusterName", clusterName);
            model.setValue("instanceName", instanceName);
            model.setValue("value", value);
            model.setValue("objectName", reference.toString()); // hidden variable 
        }
    }
    
    public void saveTokenEditTable(RequestContext ctx, HandlerContext handlerCtx) 
            throws ModelControlException  {
	View view = handlerCtx.getView();
	DescriptorContainerView descView = (DescriptorContainerView)
	    (((ViewBase)view).getParentViewBean());
	ViewDescriptor vd = descView.getViewDescriptor();
        
        String[] deleteTypes = new String[]{"java.lang.String"};
        String[] createTypes = new String[]{"java.util.Properties"};
        Object[] params = null;
        
        String tokenValue = (String) handlerCtx.getInputValue("tokenValue");
        tokenValue = extractToken(tokenValue);
        if (tokenValue == null)
            return;
        CCActionTableModelInterface model =
            (CCActionTableModelInterface)handlerCtx.getInputValue(MODEL);
        model.beforeFirst();
        
        while(model.next()) {
            String objectName = (String) model.getValue("objectName");
            String value = (String) model.getValue("value");
            //System.out.print("saveTokens, on Object: "+objectName);
            //System.out.println("        "+tokenValue+"="+value);
            
            try {
                params = new Object[]{tokenValue};
                MBeanUtil.invoke(objectName, "deleteSystemProperty", params, deleteTypes);
            } catch (Exception ex) {
                // ignore
            }
            if (value != null && value.length() > 0) {
                Properties newProp = new Properties();
                newProp.setProperty(tokenValue, value);
                params = new Object[]{newProp};
                MBeanUtil.invoke(objectName, "createSystemProperties", params, createTypes);
            }
        }
    }
    
    public void beginTokensPageTitleDisplay(RequestContext ctx, HandlerContext handlerCtx) {
        CCPageTitleTag tag = (CCPageTitleTag)handlerCtx.getEvent().getSource();
        String titleKey = (String) handlerCtx.getInputValue("titleKey");
        String params = (String) handlerCtx.getInputValue("params");

		if(titleKey == null || titleKey.length() == 0) {
			titleKey = "tokens.ConfigPageTitle";
		}

        String msg = Util.getMessage(titleKey, new Object[]{params});
        tag.setPageTitleText(msg);
    }
    
    public void removeDollarSign(RequestContext ctx, HandlerContext handlerCtx) {
        String in = (String) handlerCtx.getInputValue("systemProp");
        handlerCtx.setOutputValue("result", extractToken(in));
    }
    
    public void loadConfigSystemProperties(RequestContext ctx, HandlerContext handlerCtx) {
	CCActionTableModelInterface model = (CCActionTableModelInterface)
            handlerCtx.getInputValue(MODEL);
        ((DefaultModel)model).clear();
        Properties props = (Properties) handlerCtx.getInputValue("properties");
        String linkText = Util.getMessage("props.instanceValues");
        try {
            Enumeration ee = props.propertyNames();
            while (ee.hasMoreElements()) {
                String name = (String)ee.nextElement();
                model.appendRow();
                model.setValue(PROPERTY_NAME, name);
                model.setValue(PROPERTY_VALUE, props.getProperty(name));
                model.setValue("instanceValuesHref", name);
                model.setValue("instanceValues", linkText);
                model.setRowSelected(false);
            }
        } catch (Exception ex) {
            throw new FrameworkException("loadConfigSystemProperties: Loading error. ", ex);
        }
    }

    public String endExtendedTextDisplay(RequestContext ctx, HandlerContext handlerCtx) {
        ChildContentDisplayEvent ev = (ChildContentDisplayEvent)handlerCtx.getEvent();
        String html = ev.getContent();

        if ((ev.getSource() instanceof CCTextFieldTag) == false) 
            return html; // just in case.
        
        if (html == null || html.length() == 0)
            return html;
        
        String value = Util.extractHtmlProp(html, "value");
        if (value == null || value.length() == 0)
            return html;
        value = value.trim();
        
        // check to see if the size of the text box need adjusting....
        String sizeStr = Util.extractHtmlProp(html, "size");
        if (sizeStr != null && sizeStr.length() > 0) {
            int currentSize = 0;
            try {
                currentSize = Integer.parseInt(sizeStr);
                int size = ((value.length() + 4) / 8) * 10 ;
                if (size > 100) size = 100;
                if (currentSize < size) {
                    html = Util.removeHtmlProp(html, "size");
                    html = Util.addHtmlProp(html, ("size="+size));
                    //System.out.println("........> current/new size: "+currentSize+"  "+size);
                }
            } catch (Exception ex) {
                // ignore
            }
        }
        
        int j = value.indexOf("${");
        if (j >= 0) {
            int i = value.indexOf('}');
            if (i<0) i = value.length();
            value = value.substring(j+2,i);
        } else {
            return html;
        }
        String name = Util.extractHtmlProp(html, "name");
        int i = name.indexOf('.');
        String listPage = name;
        if (i>0) 
            listPage = name.substring(0,i);
        NonSyncStringBuffer href = new NonSyncStringBuffer();
        String editKeyValue = (String) ctx.getRequest().getAttribute("editKeyValue");
        href.append("\n<a href=\"../admingui/tokensEdit?attrValue=") 
            .append(Util.URLencode(ctx, value))
            .append("&listPage=").append(listPage);
        if (editKeyValue != null && editKeyValue.length() > 0)
            href.append("&editKeyValue=").append(Util.URLencode(ctx, editKeyValue));
		if(value.startsWith("com.sun.aas")) {
			//Display "Description" for href link
        	href.append("\">&nbsp;")
            	.append(Util.getMessage("common.Description"))
            	.append("</a>");
			
		}
		else {
			//Display "Actual Values" for href link
        	href.append("\">&nbsp;")
            	.append(Util.getMessage("props.actualValues"))
            	.append("</a>");
		}
        
        return html + href;
    }
    
//  Added this to the framework
//    public void beginExtendedTextDisplay(RequestContext ctx, HandlerContext handlerCtx) {
//        Object tag = handlerCtx.getEvent().getSource();
//        if (tag instanceof CCTextFieldTag) {
//            ((CCTextFieldTag)tag).setLocalizeDisplayFieldValue("false");
//        }
//    }

    public static final String MODEL            = "model";
    public static final String PROPERTY_NAME	= "propertyName";
    public static final String PROPERTY_VALUE 	= "propertyValue";
}
