/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * TableHandlers.java
 *
 * Created on March 16, 2004, 3:13 PM
 */

package com.sun.enterprise.tools.admingui.handlers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestContextImpl;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.ViewBeanManager;
import com.iplanet.jato.model.DefaultModel;
import com.iplanet.jato.model.Model;
import com.iplanet.jato.util.RootCauseException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBase;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.DisplayField;

import javax.management.MBeanException;
import javax.management.ObjectName;
import javax.management.AttributeList;
import javax.management.Attribute;

import javax.servlet.ServletRequest;

import com.sun.enterprise.tools.guiframework.exception.FrameworkException;
import com.sun.enterprise.tools.guiframework.model.ModelManager;
import com.sun.enterprise.tools.guiframework.view.DescriptorContainerView;
import com.sun.enterprise.tools.guiframework.view.HandlerContext;
import com.sun.enterprise.tools.guiframework.view.ViewDescriptorManager;
import com.sun.enterprise.tools.guiframework.view.descriptors.ViewDescriptor;
import com.sun.enterprise.tools.guiframework.view.descriptors.CCActionTableDescriptor;
import com.sun.enterprise.tools.guiframework.view.event.BeforeCreateEvent;
import com.sun.enterprise.tools.guiframework.view.event.ErrorEvent;
import com.sun.web.ui.model.CCActionTableModelInterface;
import com.sun.web.ui.view.table.CCActionTable;
import com.sun.web.ui.view.html.CCButton;
import com.sun.web.ui.taglib.pagetitle.CCPageTitleTag;

import com.sun.enterprise.tools.admingui.util.MBeanUtil;
import com.sun.enterprise.tools.admingui.util.Util;
import com.sun.enterprise.tools.admingui.ConfigProperties;

import com.sun.enterprise.transaction.monitor.JTSMonitorMBean;

import com.sun.enterprise.admin.servermgmt.RuntimeStatus;
import com.sun.enterprise.admin.servermgmt.RuntimeStatusList;


/**
 *
 * @author  ACER  USER
 */
public class TableHandlers {
    
  
    
    public void executeMethod(RequestContext ctx, HandlerContext handlerCtx) {
        // Executes the given method on the selected rows of the table.
        //
	View view = handlerCtx.getView(); // this return the CCButton
	DescriptorContainerView descView = 
            (DescriptorContainerView)(((ViewBase)view).getParentViewBean());
	ViewDescriptor vd = descView.getViewDescriptor();
	String childName = (String)handlerCtx.getInputValue("tableChildName");
	if(childName == null) {
	    throw new FrameworkException("executeMethod: childName not specified", vd, view);
	}
        
	ViewDescriptor tableDescriptor = vd.getChildDescriptor(childName);
	if (tableDescriptor == null) {
	    throw new FrameworkException("executeMethod: tableDescriptor is null", vd, view);
	}
	if(!(tableDescriptor instanceof CCActionTableDescriptor)) {
	    throw new FrameworkException(
                "executeMethod: tableDescriptor is of wrong type", tableDescriptor, view);
	}
        CCActionTableModelInterface model = 
            ((CCActionTableDescriptor)tableDescriptor).getModel();
	String method = (String)handlerCtx.getInputValue("method");
        if (method == null) {
	    throw new FrameworkException("executeMethod: method name is null", vd, view);
        }
        
	model.setRowSelectionType("multiple");
        String objectName = null;
	try {
	    model.beforeFirst();
	    while(model.next()) {
		if (model.isRowSelected()) {
                    objectName = (String)model.getValue("objectName");
                    if (objectName == null) 
                        continue; // should be an error.
                    MBeanUtil.invoke(objectName, method, null, null);
		    model.setRowSelected(false);
                }
            }
	} catch (Exception ex) {
	    throw new FrameworkException("Error while invoking '" + method +
                "' on " + objectName, ex, tableDescriptor, view);
        }
	ContainerViewBase containerView = 
            (ContainerViewBase)(tableDescriptor.getView(ctx).getParent());
	containerView.removeChild(tableDescriptor.getName());
	((DefaultModel)model).clear();
    }
    
    public void deleteHandler(RequestContext ctx, HandlerContext handlerCtx) {
	View view = handlerCtx.getView();
	DescriptorContainerView descView = (DescriptorContainerView)(((ViewBase)view).getParentViewBean());
	ViewDescriptor vd = descView.getViewDescriptor();
	String childName = (String)handlerCtx.getInputValue("tableChildName");
	if(childName == null) {
	    throw new FrameworkException("deleteHandler: childName not specified", vd, view);
	}
        
	ViewDescriptor tableDescriptor = vd.getChildDescriptor(childName);
	if (tableDescriptor == null) {
	    throw new FrameworkException("deleteHandler: tableDescriptor is null", vd, view);
	}
	if(!(tableDescriptor instanceof CCActionTableDescriptor)) {
	    throw new FrameworkException("deleteHandler: tableDescriptor is of wrong type", tableDescriptor, view);
	}
        CCActionTableModelInterface model = ((CCActionTableDescriptor)tableDescriptor).getModel();
        
	String deleteKey = (String)handlerCtx.getInputValue("deleteKey");
	String deleteMethodName = (String)handlerCtx.getInputValue("deleteMethodName");
	String objectName = (String)handlerCtx.getInputValue("rowObjectName");
	String cascade = (String)handlerCtx.getInputValue("deleteWithCascade");
	String deleteTarget = (String)handlerCtx.getInputValue("deleteTarget");
	Boolean isResource = (Boolean)handlerCtx.getInputValue("isResource");
        Boolean isLifecycleModule = (Boolean)handlerCtx.getInputValue("isLifecycleModule");
	
	if (objectName == null) {
	    throw new FrameworkException("No ObjectName  specified", tableDescriptor, view);
	}
	if (deleteKey == null) {
	    throw new FrameworkException("No delete key specified", tableDescriptor, view);
	}
	if (deleteMethodName == null) {
                throw new FrameworkException("deleteMethodName must be specified", tableDescriptor, view);
	}
	model.setRowSelectionType("multiple");
	try {
	    model.beforeFirst();
	    // from the model, get the child that has the needed value...
	    while(model.next()) {
		if (model.isRowSelected()) {
                    if (deleteMethodName != null) {
                        deleteTableRow(model.getValue(deleteKey), objectName, deleteMethodName, 
                            cascade, deleteTarget, isResource, isLifecycleModule);
                    }
		    model.setRowSelected(false);
                }
            }
	} catch (Exception ex) {
	    throw new FrameworkException("Error while deleting from: '"+
		tableDescriptor.getName()+"'", ex, tableDescriptor, view);
        }
	ContainerViewBase containerView = 
            (ContainerViewBase)(tableDescriptor.getView(ctx).getParent());
	containerView.removeChild(tableDescriptor.getName());
	((DefaultModel)model).clear();
    }

    //Need to write a new method bcz the signature is different.
    public void deleteMBean(RequestContext ctx, HandlerContext handlerCtx) {
	View view = handlerCtx.getView();
	DescriptorContainerView descView = (DescriptorContainerView)(((ViewBase)view).getParentViewBean());
	ViewDescriptor vd = descView.getViewDescriptor();
	String childName = (String)handlerCtx.getInputValue("tableChildName");
	if(childName == null) {
	    throw new FrameworkException("deleteHandler: childName not specified", vd, view);
	}
        
	ViewDescriptor tableDescriptor = vd.getChildDescriptor(childName);
	if (tableDescriptor == null) {
	    throw new FrameworkException("deleteHandler: tableDescriptor is null", vd, view);
	}
	if(!(tableDescriptor instanceof CCActionTableDescriptor)) {
	    throw new FrameworkException("deleteHandler: tableDescriptor is of wrong type", tableDescriptor, view);
	}
        CCActionTableModelInterface model = ((CCActionTableDescriptor)tableDescriptor).getModel();
        
	String deleteKey = (String)handlerCtx.getInputValue("deleteKey");
	String deleteMethodName = (String)handlerCtx.getInputValue("deleteMethodName");
	String objectName = (String)handlerCtx.getInputValue("rowObjectName");

	if (objectName == null) {
	    throw new FrameworkException("No ObjectName  specified", tableDescriptor, view);
	}
	if (deleteKey == null) {
	    throw new FrameworkException("No delete key specified", tableDescriptor, view);
	}
	if (deleteMethodName == null) {
                throw new FrameworkException("deleteMethodName must be specified", tableDescriptor, view);
	}
	model.setRowSelectionType("multiple");
	try {
	    model.beforeFirst();
	    // from the model, get the child that has the needed value...
	    while(model.next()) {
		if (model.isRowSelected()) {
			String mbeanName = (String)model.getValue(deleteKey);
			//get the references first, to delete all the associated targets.
			String[] targets = null;
			boolean isTargetSupported = ConfigProperties.getInstance().getTargetSupported().booleanValue();	
			if(isTargetSupported) {
				targets = getReferences(objectName, "listReferencees", mbeanName);
			}
			if(targets == null || targets.length == 0) {
				targets = new String[]{ConfigProperties.getInstance().getDefaultTarget()};
			}
			for(int i =0; i < targets.length; i++) {
				MBeanUtil.invoke(objectName, deleteMethodName, new Object[]{targets[i], mbeanName}, new String[]{"java.lang.String", "java.lang.String"});
			}
			
		    model.setRowSelected(false);
                }
            }
	} catch (Exception ex) {
	    throw new FrameworkException("Error while deleting from: '"+
		tableDescriptor.getName()+"'", ex, tableDescriptor, view);
        }
	ContainerViewBase containerView = 
            (ContainerViewBase)(tableDescriptor.getView(ctx).getParent());
	containerView.removeChild(tableDescriptor.getName());
	((DefaultModel)model).clear();
    }

	private String[] getReferences(String objectName, String methodName, String key) {
		ObjectName[] refs = (ObjectName[])MBeanUtil.invoke(objectName, methodName, new Object[]{key}, new String[]{"java.lang.String"});
		String[] targets = null;
		if(refs != null) {
			targets = new String[refs.length];
		}
		for (int i=0; refs != null && i < refs.length; i++) {
			targets[i] = refs[i].getKeyProperty("name");
		}
		return targets;
	}

    private void deleteTableRow(Object key, String objectName, String methodName, 
            String cascade, String target, Boolean isResource, Boolean isLifecycleModule) throws Exception {
        Object[] params = null;
        String[] types = null;
        
        String defaultTarget = target;
        if (isResource != null && isResource.booleanValue() == true) {
            deleteResourceReferences(key.toString());
            defaultTarget = ConfigProperties.getInstance().getDefaultTarget();
        }
        if (isLifecycleModule != null && isLifecycleModule.booleanValue() == true) {
            deleteLifecycleReferences(key.toString());
            defaultTarget = ConfigProperties.getInstance().getDefaultTarget();
        }

        if (cascade != null && cascade.equals("true")) {
            if (defaultTarget == null) {
                params = new Object[]{key, new Boolean(true)};
                types = new String[]{"java.lang.String", "java.lang.Boolean"};
            }
            else {
                params = new Object[]{key, new Boolean(true), defaultTarget};
                types = new String[]{"java.lang.String", "java.lang.Boolean", "java.lang.String"};
            }
        }
        else { // cascade == false
            if (defaultTarget == null) {
                params = new Object[]{key};
                types = new String[]{"java.lang.String"};
            }
            else {
                params = new Object[]{key, defaultTarget};
                types = new String[]{"java.lang.String", "java.lang.String"};
            }
        }
        //System.out.println("................. calling delete............");
        //System.out.println("  "+objectName+"  "+methodName);
        //for (int i=0; i<params.length; i++)
        //    System.out.println("        "+params[i]);
        MBeanUtil.invoke(objectName, methodName, params, types);
    }
    
    private void deleteResourceReferences(String resourceName) 
        throws Exception {
        if (ConfigProperties.getInstance().getTargetSupported().booleanValue() == false) {
                return;
        }
        Object[] param = new Object[]{resourceName};
        String[] type = new String[]{"java.lang.String"};
        ObjectName[] references = 
            (ObjectName[])MBeanUtil.invoke("com.sun.appserv:type=resources,category=config",
                "listReferencees", 
                param, type);
        for(int i = 0; i < references.length; i++) {
            String targetName = (String)MBeanUtil.getAttribute(
                references[i], "name");
            MBeanUtil.invoke(
                "com.sun.appserv:type=resources,category=config",
                "deleteResourceReference", 
                new Object[]{targetName, resourceName},
                new String[]{"java.lang.String", "java.lang.String"});
        }
    }
    
    private void deleteLifecycleReferences(String lifecycleName) 
        throws Exception {
        if (ConfigProperties.getInstance().getTargetSupported().booleanValue() == false) {
                return;
        }
        Object[] param = new Object[]{lifecycleName};
        String[] type = new String[]{"java.lang.String"};
        ObjectName[] references = 
            (ObjectName[])MBeanUtil.invoke("com.sun.appserv:type=applications,category=config",
                "listReferencees", 
                param, type);
        for(int i = 0; i < references.length; i++) {
            String targetName = (String)MBeanUtil.getAttribute(
                references[i], "name");
            MBeanUtil.invoke(
                "com.sun.appserv:type=applications,category=config",
                "removeLifecycleModuleReference", 
                new Object[]{lifecycleName, targetName},
                new String[]{"java.lang.String", "java.lang.String"});
        }
    }
    
    
    
    private Object getName(Object obj) {
        // monitor objects names are suitable for showing in the GUI, need to 
        // call "getName()" to get to show in the GUI.
        if (obj instanceof String) {
            String name = (String) obj;
            if (name.indexOf("category=monitor") >= 0)
                return MBeanUtil.invoke(name, "getName", null, null);
        }
        return obj;
    }
    
    private CCActionTableDescriptor getTableDescriptor(HandlerContext handlerCtx) {
	View view = handlerCtx.getView();
        // Find the CCActionTableDescriptor
        ViewDescriptor desc = null;
        View tableView = (View)handlerCtx.getInputValue("tableView");
        if (tableView != null) {
            desc = ((DescriptorContainerView)tableView).getViewDescriptor();
        }
        else if (handlerCtx.getEvent() instanceof BeforeCreateEvent) {
            desc = ((BeforeCreateEvent)handlerCtx.getEvent()).getViewDescriptor();
        } else if (view instanceof DescriptorContainerView) {
            desc = ((DescriptorContainerView)view).getViewDescriptor();
        }
        if ((desc == null) || !(desc instanceof CCActionTableDescriptor)) {
            throw new FrameworkException("Unable to determine "+
                "CCActionTableDescriptor.  This handler should be invoked "+
                "from a CCActionTable.", desc, view);
        }
        return (CCActionTableDescriptor)desc;
    }
    
    public void resetXMLinModel(RequestContext ctx, HandlerContext handlerCtx) {
        CCActionTableDescriptor ccDesc = getTableDescriptor(handlerCtx);
        ccDesc.resetXML();
    }
    
    public void loadTableModel(RequestContext ctx, HandlerContext handlerCtx) {
        // Get the CCActionTableModel
        CCActionTableDescriptor ccDesc = getTableDescriptor(handlerCtx);
        CCActionTableModelInterface model = ccDesc.getModel();
        ((DefaultModel)model).clear();
        
        ArrayList displayNamesList = (ArrayList)handlerCtx.getInputValue("displayNames");
        Object keysObj = handlerCtx.getInputValue("keys"); //object names
        Object[] keys = null;
        if (keysObj instanceof Object[]) {
            keys = (Object[])keysObj;
        } else if (keysObj instanceof List) {
            List keysList = (List)keysObj;
            keys = new Object[keysList.size()];
            for (int i=0; i < keys.length; i++) {
               keys[i] = keysList.get(i);
            }
        }

        if (keys == null) {
            return; //nothing to load..
        }

        ArrayList modelNamesList = (ArrayList)handlerCtx.getInputValue("attributeNames");
        String[] modelNames = null;
        if (modelNamesList != null)
            modelNames = (String[])modelNamesList.toArray(new String[modelNamesList.size()]);
        if (keys instanceof String[] || modelNames == null) {
            // When there is no model names, use the ObjectName (keys) as the 
            // value for the display name.
            
            for (int rowNo = 0; rowNo < keys.length; rowNo++) {
                model.appendRow();
                model.setValue((String)displayNamesList.get(0), getName(keys[rowNo].toString()));
                model.setValue("objectName", keys[rowNo].toString());
            }
        }
        else if (keys instanceof ObjectName[]) {
            ObjectName[] objNames = (ObjectName[])keys;
            if (isMixed(modelNames)) {
                loadTable(objNames, modelNames, displayNamesList, model);
            } else {
                loadTableByGroup(objNames, modelNames, displayNamesList, model);
            }
        }
    }

    /*
    public void setTableColumn(RequestContext ctx, HandlerContext handlerCtx) throws Exception {
        CCActionTableDescriptor tableDescriptorDesc = getTableDescriptor(handlerCtx);
        CCActionTableModelInterface model = tableDescriptorDesc.getModel();
        Object value = (handlerCtx.getInputValue("value"));
        String columnName = (String)handlerCtx.getInputValue("columnName");
        
        try {
            if (value instanceof Object[]) {
                Object[] valuesArray = (Object[])value;
                model.beforeFirst();
                for (int i = 0; i < valuesArray.length; i++) {
                    if (!model.next())
                        break;
                    model.setValue(columnName, valuesArray[i]);
                }
            }
            else {
                model.beforeFirst();
                while(model.next())
                    model.setValue(columnName, value);
            }
        } catch (Exception ex) {
                throw new FrameworkException("Error setting column : '" + columnName + "'",	ex);
        }
    }
    
*/
    private boolean isMixed(String[] names) {
        // return true if the name list contains both attribute and method names
        for (int i=0; i<names.length; i++) {
            if (names[i] != null && names[i].indexOf('@') == 0)
                return true;
        }
        return false;
    }
    
    private void loadTableByGroup(ObjectName[] objNames, String[] modelNames, 
            ArrayList displayNamesList, CCActionTableModelInterface model) {
        for (int rowNo = 0; rowNo < objNames.length; rowNo++) {
            // getAttributes for the given objectName...
            AttributeList attrList = 
                MBeanUtil.getAttributes(objNames[rowNo].toString(), modelNames);
            model.appendRow();

            for (int i = 0,  colNo = 0; i < attrList.size(); i++) {
                Attribute attr = (Attribute)attrList.get(i);

                while (colNo <  modelNames.length && 
                       ! attr.getName().equals(modelNames[colNo])) {
                    colNo++;
                }
                if (colNo < modelNames.length) {
                    Object attrValue = attr.getValue();
                    if (attrValue != null) {
                        attrValue = attrValue.toString();
                    }
                    model.setValue((String)displayNamesList.get(colNo), 
                                    getName(attr.getValue()));
                }
            }
            model.setValue("objectName", objNames[rowNo].toString());
            model.setValue("objectType", objNames[rowNo].getKeyProperty("type"));
        }
    }

    
    private void loadTable(ObjectName[] objNames, String[] modelNames, 
            ArrayList displayNamesList, CCActionTableModelInterface model) {
        // loads the table with attribute values either from individual calls
        // to get the attr value or by a method call.
        for (int rowNo = 0; rowNo < objNames.length; rowNo++) {
            // getAttributes for the given objectName...
            model.appendRow();
            
            for (int colNo = 0; colNo < modelNames.length; colNo++) {
                model.setValue((String)displayNamesList.get(colNo), 
                    getValue(objNames[rowNo], modelNames[colNo]));
                model.setValue("objectName", objNames[rowNo].toString());
                model.setValue("objectType", objNames[rowNo].getKeyProperty("type"));
            }
        }
    }

    private String getValue(ObjectName objName, String attrName) {
        Object value = null;
        if (attrName.indexOf('@') == 0 && attrName.length() > 3) {
            String method = attrName.substring(2,  attrName.length()-1);
            try {
                value = MBeanUtil.invoke(objName, method, null, null);
            } catch (Exception ex) {
                if (method.equals("getRuntimeStatus"))
                    // special case hack
                    return TargetHandlers.getStatusHtml(value);
                else 
                    value = ex.getMessage();
            }
        } else {
            value =  MBeanUtil.getAttribute(objName, attrName);
        }
        String result = "";
        if (value != null) {
            if (value instanceof RuntimeStatus || value instanceof RuntimeStatusList) {
                result = TargetHandlers.getStatusHtml(value);
            } else {
                result = value.toString();
            }
        }
        return result;
    }
    
    /**
     *
     *	<P>ENSURE_MODEL_ROWS_ARRAY is a request attribute that contains the
     *	array to iterate over, ENSURE_MODEL_ROWS_MODEL should contain the model
     *	to ensure has the right number of rows.</P>
     */
    public void ensureModelRows(RequestContext ctx, HandlerContext handlerCtx) {
        ViewDescriptor desc = null;
        if (handlerCtx.getEvent() instanceof BeforeCreateEvent)
            desc = ((BeforeCreateEvent)handlerCtx.getEvent()).getViewDescriptor();
        else {
	    throw new FrameworkException("ensureModelRows can only be called in BeforeCreate event handler!", desc, handlerCtx.getView());
        }
        String dummyArrayName = "";
        while (desc != null) {
            if (dummyArrayName.equals("") == false)
                dummyArrayName = "." + dummyArrayName;
            dummyArrayName = desc.getName() + dummyArrayName;
            desc = desc.getParent();
        }
        dummyArrayName += "." + "rowCounter";

        ServletRequest req = ctx.getRequest();
	Object arr[] = (Object [])req.getParameterValues(dummyArrayName);

        // Get the ServletRequest
	//Object arr[] = (Object [])req.getAttribute(ENSURE_MODEL_ROWS_ARRAY);
	if (arr == null) {
	    // Nothing to do
	    return;
	}

	// NOTE: CCActionTableModelInterface defines appendRow() and
	//	 getNumRows()... might want to use this model instead.
	//	 However, DefaultModel is more generic, so I am using this for
	//	 now.
	DefaultModel model = (DefaultModel)handlerCtx.getInputValue(MODEL);
	if (model == null) {
	    throw new FrameworkException("Model cannot be null!", desc, handlerCtx.getView());
	}

	// Iterate over the array, adding rows to the Model
	int rowsToAdd = arr.length;
	rowsToAdd -= model.getNumRows();
	for (int count=0; count<rowsToAdd; count++) {
	    model.appendRow();
	}
    }
    
    
    //FIXME : more work to do here....
    public void handleTableMenuAction(RequestContext ctx, HandlerContext handlerCtx) {
        String action = (String)handlerCtx.getInputValue("action");

        ViewDescriptor desc = null;
        View tableView = (View)handlerCtx.getInputValue("tableView");
        if (tableView != null) {
            desc = ((DescriptorContainerView)tableView).getViewDescriptor();
        }
        CCActionTableDescriptor ccDesc = (CCActionTableDescriptor)desc;
        
        CCActionTableModelInterface model = ccDesc.getModel();
	try {
	    model.beforeFirst();
	    // from the model, get the child that has the needed value...
	    while(model.next()) {
                if (Util.isLoggableFINER()) 
                    Util.logFINER("isRowSelected = " + model.isRowSelected());
            }
        }catch (Exception ex){
            ex.printStackTrace();
        }
    }

    public void getTableFilterValue(RequestContext ctx, HandlerContext handlerCtx) {
        String filterValue = (String)handlerCtx.getInputValue("displayFieldValue");
        if (filterValue != null && 
            filterValue.equals(CCActionTable.FILTER_ALL_ITEMS_OPTION)) {
                filterValue = null;
        }
        handlerCtx.setOutputValue("filterValue", filterValue);
    }
    
    public void loadTransactionIds(RequestContext ctx, HandlerContext handlerCtx) {
	View view = handlerCtx.getView();
        // Find the CCActionTableDescriptor
        ViewDescriptor desc = null;
        if (handlerCtx.getEvent() instanceof BeforeCreateEvent) {
            desc = ((BeforeCreateEvent)handlerCtx.getEvent()).getViewDescriptor();
        } else if (view instanceof DescriptorContainerView) {
            desc = ((DescriptorContainerView)view).getViewDescriptor();
        }
        if ((desc == null) || !(desc instanceof CCActionTableDescriptor)) {
            throw new FrameworkException("Unable to determine "+
                "CCActionTableDescriptor.  This handler should be invoked "+
                "from a CCActionTable.", desc, view);
        }
        // Get the CCActionTableModel
        CCActionTableDescriptor ccDesc = (CCActionTableDescriptor)desc;
        CCActionTableModelInterface model = ccDesc.getModel();

        ArrayList displayName = (ArrayList)handlerCtx.getInputValue("displayNames");
        List maps = (List)handlerCtx.getInputValue("maps"); 

        if (maps == null) {
            return; //nothing to load..
        }

        for (Iterator iter = maps.iterator(); iter.hasNext();) {
            java.util.Map m = (java.util.Map)iter.next();
            model.appendRow();
            model.setValue((String)displayName.get(0), (String)m.get(JTSMonitorMBean.TRANSACTION_ID));
            model.setValue((String)displayName.get(1), (String)m.get(JTSMonitorMBean.STATE));
            model.setValue((String)displayName.get(2), (String)m.get(JTSMonitorMBean.ELAPSED_TIME));
            model.setValue((String)displayName.get(3), (String)m.get(JTSMonitorMBean.COMPONENT_NAME));
            model.setValue((String)displayName.get(4), (String)m.get(JTSMonitorMBean.RESOURCE_NAMES));
        }
    }
    
    public void setTransactionPageTitle(RequestContext ctx, HandlerContext handlerCtx) {
        Object obj = handlerCtx.getEvent().getSource();
        //System.out.println("OBJECT ="+obj.getClass().getName());
        CCPageTitleTag tag = (CCPageTitleTag)handlerCtx.getEvent().getSource();
        AttributeList state = (AttributeList)handlerCtx.getInputValue("state");
        String status = Util.getMessage("common.unknown");
        if (state != null && state.get(0) != null) {
            String value = (String)((Attribute)state.get(0)).getValue();
            status = value.equals("False")?Util.getMessage("transactionId.UnFreeze"):Util.getMessage("transactionId.Freeze");
        }
        String bundle = "com.sun.enterprise.tools.admingui.resources.Resources";
        String pageTitle = tag.getPageTitleText();
        String localizedString = Util.getMessage(bundle, pageTitle, new Object[]{status});
        tag.setPageTitleText(localizedString);
    }
    
    public void setTransactionDisplayFieldValues(RequestContext ctx, HandlerContext handlerCtx) {
        View childView = handlerCtx.getView();
	DescriptorContainerView view = (DescriptorContainerView)(((ViewBase)childView).getParentViewBean());
        AttributeList state = (AttributeList)handlerCtx.getInputValue("state");
        String value = (String)((Attribute)state.get(0)).getValue();
        String status = value.equals("False")?Util.getMessage("transactionId.Freeze"):Util.getMessage("transactionId.UnFreeze");
        DisplayField stateField = (DisplayField)view.getDisplayField("Status");
	stateField.setValue(value);
        CCButton button = (CCButton)childView;
        button.setDisplayLabel(status);
    }
    
    public void setTransactionState(RequestContext ctx, HandlerContext handlerCtx) {
        String objectName = (String)handlerCtx.getInputValue("objectName");
        View childView = handlerCtx.getView();
	DescriptorContainerView view = (DescriptorContainerView)(((ViewBase)childView).getParentViewBean());
        String state = (String)view.getDisplayFieldValue("Status");
        String methodName = state.equals("False")?"freeze":"unfreeze";
        MBeanUtil.invoke(objectName, methodName, null, null);
    }

    private void deleteCluster(String clusterName) {
        removeLbRefs(clusterName);  // first see if there are load balancer refs and remove.
        boolean running = true;
        // see if the cluster is running...
 	try {
            RuntimeStatusList status = (RuntimeStatusList)MBeanUtil.invoke(
                "com.sun.appserv:type=clusters,category=config", 
                "getRuntimeStatus", 
                new Object[]{clusterName}, 
                new String[]{"java.lang.String"});
                running = status.anyRunning();
        } catch (Exception ex) {
            // log the error and keep going.
            if (Util.isLoggableFINE())
                Util.logFINE(ex);
        }
        if (running) {
            // try to stop the cluster.
            try {
                MBeanUtil.invoke(
                    "com.sun.appserv:type=clusters,category=config", 
                    "stopCluster", 
                    new Object[]{clusterName}, 
                    new String[]{"java.lang.String"});
            } catch (Exception ex) {
                // if can't stop a running cluster, bail out.
                throw new FrameworkException(ex);
            }
        }
 	try {
            // get the list of instances of the cluster
            ObjectName[] objectNames = (ObjectName[])MBeanUtil.invoke(
                "com.sun.appserv:type=servers,category=config", 
                "listServerInstances", 
                new Object[]{clusterName}, 
                new String[]{"java.lang.String"});
            // delete the instances one by one.
            for (int i = 0; i < objectNames.length; i++) {
                //System.out.print(">>> objectNames[i]: " + objectNames[i]);
                String instanceName = objectNames[i].getKeyProperty("name");
                
                String[] modules = (String[])MBeanUtil.invoke(
                    "com.sun.appserv:type=servers,category=config", 
                    "deleteServerInstance",
                    new Object[]{instanceName}, 
                    new String[]{"java.lang.String"});
            }
            // delete the cluster itself.
            MBeanUtil.invoke(
                "com.sun.appserv:type=clusters,category=config", 
                "deleteCluster", 
                new Object[]{clusterName}, 
                new String[]{"java.lang.String"});
	} catch (Exception ex) {
            if (Util.isLoggableFINE()) {
                Util.logFINE(ex);
            }
            throw new FrameworkException(ex);
        }
    }
    
   private void removeLbRefs(String clusterName) {
       Object params[] = {clusterName};
       String[] types= new String[]{"java.lang.String"};
       String[] lbs = null;
       // first see if there are lb refs...
       try {
           lbs =  (String[])MBeanUtil.invoke("com.sun.appserv:type=olbadmin,category=config", "getLBConfigsForCluster", params, types);
           
       } catch (Exception ex) {
           // log the error and keep going.
           if (Util.isLoggableFINE())
               Util.logFINE(ex);
       }
       // remove lb refs from cluster       
       if (lbs != null) {
           try {
               for (int i = 0; i < lbs.length; i++) {
                  MBeanUtil.invoke("com.sun.appserv:type=lb-config,name="+lbs[i]+",category=config", "removeClusterRefByRef", params, types);
               }
           } catch (Exception ex) {
              throw new FrameworkException(ex);
           }
       }
    }
   
    public void deleteClusterAndInstances(RequestContext ctx, HandlerContext handlerCtx) {
        // Executes the given method on the selected rows of the table.
        //
	View view = handlerCtx.getView(); // this return the CCButton
	DescriptorContainerView descView = 
            (DescriptorContainerView)(((ViewBase)view).getParentViewBean());
	ViewDescriptor vd = descView.getViewDescriptor();
	String childName = (String)handlerCtx.getInputValue("tableChildName");
	if(childName == null) {
	    throw new FrameworkException(
                "deleteClusterAndInstances: childName not specified", vd, view);
	}
        
	ViewDescriptor tableDescriptor = vd.getChildDescriptor(childName);
	if (tableDescriptor == null) {
	    throw new FrameworkException(
                "deleteClusterAndInstances: tableDescriptor is null", vd, view);
	}
	if(!(tableDescriptor instanceof CCActionTableDescriptor)) {
	    throw new FrameworkException(
                "deleteClusterAndInstances: tableDescriptor is of wrong type", tableDescriptor, view);
	}
        CCActionTableModelInterface model = 
            ((CCActionTableDescriptor)tableDescriptor).getModel();
        
	model.setRowSelectionType("multiple");
        String objectName = null;
	try {
	    model.beforeFirst();
	    while(model.next()) {
		if (model.isRowSelected()) {
                    objectName = (String)model.getValue("objectName");
                    if (objectName == null) 
                        continue; // should be an error.
                    deleteCluster(new ObjectName(objectName).getKeyProperty("name"));
		    model.setRowSelected(false);
                }
            }
	} catch (Exception ex) {
            if (Util.isLoggableFINE())
                Util.logFINE(ex);
            throw new FrameworkException(ex);
        }
	ContainerViewBase containerView = 
            (ContainerViewBase)(tableDescriptor.getView(ctx).getParent());
	containerView.removeChild(tableDescriptor.getName());
	((DefaultModel)model).clear();
    }
    
    public static final String MODEL            = "model";
}
