/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.guiframework.event.descriptors;


import com.iplanet.jato.view.View;

import com.sun.enterprise.tools.guiframework.view.descriptors.ViewDescriptor;
import com.sun.enterprise.tools.guiframework.FrameworkDescriptor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 *  This class describes an Event.  It contains a List of UseHandlerDescriptors
 *  and a type.  The UseHandlerDescriptors further describe where a handler's
 *  method is, and if any mappings should be performed before or after the
 *  handler method is invoked.
 */
public class EventDescriptor implements FrameworkDescriptor {

    /**
     *	Constructor.
     *
     *	@param	parent		The ViewDescriptor shich contains this Event.
     *	@param	eventType	The type of event (beginDisplay, command, etc.)
     */
    public EventDescriptor(ViewDescriptor parent, String eventType) {
	setParent(parent);
	setType(eventType);
    }


    /**
     *	This method returns the ViewDescriptor that contains this event.
     *
     *	@return The parent descriptor
     */
    public ViewDescriptor getParent() {
	return _parent;
    }


    /**
     *	This method sets the parent ViewDescriptor.
     *
     *	@param	parent	The parent ViewDescriptor
     */
    protected void setParent(ViewDescriptor parent) {
	if (parent == null) {
	    throw new RuntimeException("You must provide a the " +
		"ViewDescriptor which contains this EventDescriptor!");
	}
	_parent = parent;
    }


    /**
     *	This method returns the EventDescriptor type
     *
     *	@return	The Event descriptor type
     */
    public String getType() {
	return _eventType;
    }


    /**
     *	This method sets the event type.
     *
     *	@param	type	The event type.
     */
    protected void setType(String type) {
	if (type == null) {
            throw new IllegalArgumentException(
		"You must provide an Event type!");
	}

	// Try to find the registered event type
	_eventType = (String)_eventTypesMap.get(type.toLowerCase());
	if (_eventType == null) {
            throw new IllegalArgumentException(
		"Illegal event type: "+type);
	}
    }


    /**
     *	<P>This method allows UseHandlerDescriptors to be added.  You can add
     *	as many handlers as you desire, they will be invoked in the order they
     *	are added.</P>
     *
     *	<P>The method should be public; return void; accept 2 parameters: 1 of
     *	type "RequestContext", one of type "HandlerContext"  Example:</P>
     *
     *	<P> <BLOCKQUOTE>
     *		public void beginDisplay(
     *			RequestContext reqCtx, HandlerContext handlerCtx)
     *			throws ModelControlException
     *	    </BLOCKQUOTE></P>
     *
     *	@param desc	The UserHandlerDescriptor to add.
     */
    public void addEventHandler(UseHandlerDescriptor desc) {
	// Add to the list
	_handlers.add(desc);
    }

    
    /**
     *	This method returns the List of handlers for this descriptor.  Each
     *	item in the List is of type UseHandlerDescriptor, which in turn, refer
     *	to a HandlerDescriptor which describes the actual Method to invoke.
     *
     *	@return List of handlers for this EventDescriptor.
     *
     *	@see #addEventHandler(UseHandlerDescriptor)
     */
    public List getEventHandlers() {
	return _handlers;
    }


    /**
     *	This method allows the List of handlers to be set.
     *
     *	@param handlers	The List of UseHandlerDescriptor objects
     *
     *	@see #addEventHandler(UseHandlerDescriptor)
     */
    public void setEventHandlers(List handlers) {
	_handlers = handlers;
    }


    public interface TYPES {
	// These are the valid Event types
	String BEGIN_DISPLAY =		"beginDisplay";
	String END_DISPLAY =		"endDisplay";
	String COMMAND =		"command";
	String BEFORE_CREATE =		"beforeCreate";
	String AFTER_CREATE =		"afterCreate";
	String AFTER_REQUEST =		"afterRequest";
	String ERROR =			"error";
        String END_WIZARD =             "endWizard";
        String NEXT_WIZARD_STEP =       "nextWizardStep";  
        String PREV_WIZARD_STEP =       "prevWizardStep";  
        String GOTO_WIZARD_STEP =       "gotoWizardStep";
        String FINISH_WIZARD_STEP =     "finishWizardStep";
        String CANCEL_WIZARD_STEP =     "cancelWizardStep";        
    }

    private ViewDescriptor	_parent	= null;
    private String      	_eventType = null;
    private List		_handlers = new ArrayList();

    private static Map		_eventTypesMap = new HashMap();

    static {
	_eventTypesMap.put(TYPES.BEGIN_DISPLAY.toLowerCase(), TYPES.BEGIN_DISPLAY);
	_eventTypesMap.put(TYPES.END_DISPLAY.toLowerCase(), TYPES.END_DISPLAY);
	_eventTypesMap.put(TYPES.COMMAND.toLowerCase(), TYPES.COMMAND);
	_eventTypesMap.put(TYPES.BEFORE_CREATE.toLowerCase(), TYPES.BEFORE_CREATE);
	_eventTypesMap.put(TYPES.AFTER_CREATE.toLowerCase(), TYPES.AFTER_CREATE);
	_eventTypesMap.put(TYPES.AFTER_REQUEST.toLowerCase(), TYPES.AFTER_REQUEST);
	_eventTypesMap.put(TYPES.ERROR.toLowerCase(), TYPES.ERROR);
	_eventTypesMap.put(TYPES.END_WIZARD.toLowerCase(), TYPES.END_WIZARD);   
	_eventTypesMap.put(TYPES.NEXT_WIZARD_STEP.toLowerCase(), TYPES.NEXT_WIZARD_STEP);   
	_eventTypesMap.put(TYPES.PREV_WIZARD_STEP.toLowerCase(), TYPES.PREV_WIZARD_STEP);   
	_eventTypesMap.put(TYPES.GOTO_WIZARD_STEP.toLowerCase(), TYPES.GOTO_WIZARD_STEP);   
	_eventTypesMap.put(TYPES.FINISH_WIZARD_STEP.toLowerCase(), TYPES.FINISH_WIZARD_STEP);   
	_eventTypesMap.put(TYPES.CANCEL_WIZARD_STEP.toLowerCase(), TYPES.CANCEL_WIZARD_STEP);           
    }
}
