/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Constructors
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

// construct a javascript object for maintaining scroll position via a cookie
function ccScrollCookie(name, path) {
    // call the old base constructor
    this.ccScrollCookie(name);

    this.$path = path;
}

// this constructor is called by the one above and is left for compatability
// with 2.0 apps
function ccScrollCookie(name) {
    // All predefined properties of this object begin with '$' because
    // we don't want to store these values in the cookie.
    this.$cookieName = name;

    // Default properties.
    this.left = "0";
    this.top  = "0";

    // Object methods from cookie.js
    this.get   = ccGetCookie;
    this.load  = ccLoadCookie;
    this.reset = ccResetCookie;
    this.show  = ccShowCookie;
    this.store = ccStoreCookie;

    // Object methods from scrollCookie.js
    this.restore = ccRestoreScrollCookie;
    this.set     = ccSetScrollCookie;
}



// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Functions
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

// This function will load the cookie and restore scroll position.
function ccRestoreScrollCookie() {
    // Load cookie value.
    this.load();

    // Set scroll position.
    window.scrollTo(parseInt(this.left), parseInt(this.top));

    return true;
}

// This function will set the cookie value.
function ccSetScrollCookie() {
    // Set object properties.
    this.left = 0;
    this.top  = 0;

    var documentElement = window.document.documentElement;

    if (documentElement && documentElement.scrollTop) {
        this.left = documentElement.scrollLeft;
        this.top  = documentElement.scrollTop;
    } else {
        this.left = window.document.body.scrollLeft;
        this.top  = window.document.body.scrollTop;
    }

    // Store cookie value.
    this.store();

    return true;
}

//-->
