/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.guiframework.view;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.RequestInvocationEvent;

import com.sun.enterprise.tools.guiframework.exception.FrameworkException;
import com.sun.enterprise.tools.guiframework.view.descriptors.ViewDescriptor;
import com.sun.enterprise.tools.guiframework.view.descriptors.CCTabsDescriptor;

import com.sun.web.ui.view.tabs.CCNodeEventHandlerInterface;

import java.util.Iterator;


public class CCNodeEventHandlerViewBeanBase extends DescriptorViewBeanBase implements CCNodeEventHandlerInterface {
    /**
     *	Constructor
     */
    public CCNodeEventHandlerViewBeanBase(RequestContext context, String pageName, ViewDescriptor desc) {
	super(context, pageName, desc);
    }


    /**
     *	This method is invoked when the user click on a tab.  If the child
     *	CCTabsDescriptor is named "Tabs", then it will be found via a simple
     *	Map lookup.  However, if it is not, then the first CCTabsDescriptor
     *	found will be used.  This implies that only 1 CCTabsDescriptor may
     *	exist per ViewBean.
     *
     *	@param event The request invocation event
     *	@param nodeID The selected node id
     */
    public void nodeClicked(RequestInvocationEvent event, int nodeID) {
    	// Look for the tab component by name
	CCTabsDescriptor tabDesc =
	    (CCTabsDescriptor)getViewDescriptor().getChildDescriptor("Tabs");

	// Check to see if we found it...
	if (tabDesc == null) {
	    // We didn't find it by name... iterate through looking all the
	    // child descriptors, looking for the correct type.
	    Iterator it = getViewDescriptor().getChildDescriptors().iterator();
	    ViewDescriptor desc = null;
	    while (it.hasNext()) {
		desc = (ViewDescriptor)it.next();
		if (desc instanceof CCTabsDescriptor) {
		    tabDesc = (CCTabsDescriptor)desc;
		    break;
                }
            }
	}

	// If we still didn't find a tabDesc, then we can't proceed
	if (tabDesc == null) {
	    // FIXME: Provide a means to access Logging
	    throw new FrameworkException("No tabs defined for this page: "+
		getName(), getViewDescriptor(), this);
	}

	// get the view bean in which to forward to
	String viewBeanName = tabDesc.getViewBean(getRequestContext(), nodeID);
	if (viewBeanName != null) {
	    ViewBean next = getViewBean(viewBeanName);
	    next.forwardTo(getRequestContext());
	    return;
	} else {
	    // FIXME: Provide a means to access Logging
	    throw new FrameworkException("No nextPage defined for tab: "+
		tabDesc.getName(), getViewDescriptor(), this);
        }
    }
}
