/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.guiframework.view.descriptors;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.View;

import com.sun.enterprise.tools.guiframework.exception.FrameworkException;
import com.sun.enterprise.tools.guiframework.view.DescriptorCCDateTime;

import com.sun.web.ui.model.CCDateTimeModelInterface;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;


/**
 *
 */
public class CCDateTimeDescriptor extends DisplayFieldDescriptor {

    /**
     *	Constructor
     */
    public CCDateTimeDescriptor(String name) {
	super(name);
    }

    /**
     *
     */
    public CCDateTimeModelInterface getModel() {
	return getModel(RequestManager.getRequestContext());
    }

    /**
     *
     */
    public CCDateTimeModelInterface getModel(RequestContext ctx) {
	return (CCDateTimeModelInterface)ctx.getModelManager().getModel(
	    CCDateTimeModelInterface.class,
	    getModelInstanceName(),
	    shouldGetModelFromSession(),
	    shouldPutModelToSession());
    }

    /**
     *	This is a factory method for CCDateTime instances.
     *
     *	@param	ctx	The RequestContext
     *	@param	container	The container for the newly created 
     */
    public View getInstance(RequestContext ctx, ContainerView container, String name) {
	// Get the Model
	CCDateTimeModelInterface model = getModel(ctx);

	// Set some defaults if the model is not pre-populated
	if (model.getStartDateTime() == null) {
	    // Initialize the Model
	    // Start Date / Time
	    Date today = (Date)getParameter(START_DATE_TIME);
	    if (today == null) {
		today = new Date();
	    }
	    model.setStartDateTime(today);

	    // End Date / Time (not used)
//	    model.setEndTime(today);

	    // Make START_DATE_TIME_ONLY the default type
	    model.setType(CCDateTimeModelInterface.START_DATE_TIME_ONLY);

	    // Check to see if the developer provided a type
	    String value = (String)getParameter(DATE_TIME_TYPE);
	    if (value != null) {
		Integer type = (Integer)_typeMap.get(value);
		if (type != null) {
		    model.setType(type.intValue());
		} else {
		    throw new FrameworkException("Invalid CCDateTime type!");
		}
	    }

	    // Repeat Interval (LH BUG, NO DEFAULT!! NPE if not supplied)
	    model.setSelectedRepeatIntervalName(CCDateTimeModelInterface.WEEKLY);

	    // Repeat Limits (not used)
//	    model.setRepeatLimitUnit(CCDateTimeModelInterface.WEEKS);
//	    model.setRepeatLimitPeriod(52);
		// "*'d fields are required" Message
	    value = (String)getParameter(SHOW_REQUIRED_MESSAGE);
	    boolean booleanValue = false;
	    if (value != null) {
		booleanValue = new Boolean(value).booleanValue();
	    }
	    model.setShowRequiredMsg(booleanValue);

	    // Date
	    value = (String)getParameter(START_DATE_LABEL);
	    if (value != null) {
		model.setStartDateLabel(value);
	    }

	    // Time
	    value = (String)getParameter(START_TIME_LABEL);
	    if (value != null) {
		model.setStartTimeLabel(value);
	    }

	    // End Time (not used) (add in if other types are supported)
//	    value = (String)getParameter(END_TIME_LABEL);
//	    if (value != null) {
//		model.setEndTimeLabel(value);
//	    }
	}

	// Create the CCDateTime field
	return new DescriptorCCDateTime(ctx, name, this, container, model);
// FOR popup...
//	return new com.sun.web.ui.view.datetime.CCDateTimeWindow(container, model, name);
    }

    /**
     *
     */
    private static Map _typeMap = new HashMap();

    static {
	_typeMap.put("NORMAL", new Integer(CCDateTimeModelInterface.NORMAL));
	_typeMap.put("NO_END_TIME", new Integer(CCDateTimeModelInterface.NO_END_TIME));
	_typeMap.put("FOR_DATE_SELECTION", new Integer(CCDateTimeModelInterface.FOR_DATE_SELECTION));
	_typeMap.put("NO_REPEAT_LIMIT", new Integer(CCDateTimeModelInterface.NO_REPEAT_LIMIT));
	_typeMap.put("START_DATE_TIME_ONLY", new Integer(CCDateTimeModelInterface.START_DATE_TIME_ONLY));
    }

    /**
     *	Parameter (startDateTime) used to provide the start date time
     */
    public static final String START_DATE_TIME = "startDateTime";

    /**
     *	Parameter (startDateLabel) indicates the label for the date.
     */
    public static final String START_DATE_LABEL = "startDateLabel";

    /**
     *	Parameter (startTimeLabel) indicates the label for the time.
     */
    public static final String START_TIME_LABEL = "startTimeLabel";

    /**
     *	Parameter (endTimeLabel) indicates the label for the end time. (not
     *	currently used because datetime type is fixed to START_DATE_TIME_ONLY).
     */
    public static final String END_TIME_LABEL = "endTimeLabel";

    /**
     *	Paramter (showRequiredMessage), if set to "true" a message indicating
     *	*'d fields are required will appear.
     */
    public static final String SHOW_REQUIRED_MESSAGE = "showRequiredMessage";

    /**
     *	<P> Parameter (type) indicates the CCDateTime type.  Valid values
     *	    are:</P>
     *
     *	<UL><LI>NORMAL</LI>
     *	    <LI>NO_END_TIME</LI>
     *	    <LI>FOR_DATE_SELECTION</LI>
     *	    <LI>NO_REPEAT_LIMIT</LI>
     *	    <LI>START_DATE_TIME_ONLY</LI></UL>
     */
    public static final String DATE_TIME_TYPE = "type";
}
