/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.guiframework.view.descriptors;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.view.BasicDisplayField;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.DisplayField;
import com.iplanet.jato.view.View;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.view.html.CCButton;


/**
 *  This Descriptor is needed so that children of a CCPropertySheet can be
 *  created from the CCPropertySheet's model rather than directly.
 */
public class CCPageTitleChildDescriptor extends DisplayFieldDescriptor {

    /**
     *	Constructor
     */
    public CCPageTitleChildDescriptor(String name) {
	super(name);
    }


    /**
     *	This method returns the model associated with this View (it is actually
     *	obtained from the parent ViewDescriptor).
     */
    protected CCPageTitleModel getModel() {
	return ((CCPageTitleDescriptor)getParent()).getModel();
    }


    /**
     *	This is a factory method.
     *
     *	@param	ctx		The RequestContext
     *	@param	container	The container for the newly created 
     */
    public View getInstance(RequestContext ctx, ContainerView container, String name) {
	CCPageTitleModel model = getModel();
        if (model != null && model.isChildSupported(name)) {
            View child = model.createChild(container, name);
            
            // possibly add some default values in the model from the view desc.
            if (child instanceof DisplayField) {
                DisplayField field = (DisplayField)child;

		// Set the binding
		setBoundName(field);

		// Set the model value for this field
		Object value = (String)getParameter("value");
		if (value != null) {
		    model.setValue(name, value);
		}
                if (field instanceof CCButton) {
                    ((CCButton) field).setDisabled(isDisabled());
                }
            }
            return child;
        }
        return null;
    }
}
