/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.guiframework.view.descriptors;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.View;


/**
 *  This descriptor should be used for things such as ContentTag, CCHtmlHeader,
 *  and other ViewXML constructs which don't have a corresponding View class.
 *  The getInstance() method always returns null.
 */
public class NoViewDescriptor extends DisplayFieldDescriptor {

    /**
     *	Creates a View Descriptor which will not have a corresponding View.
     */
    public NoViewDescriptor(String name) {
	super(name);
    }


    /**
     *	This is a factory method for instances, however, for this descriptor
     *	there is no peer View.  This method always returns null.
     *
     *	@param	ctx		The RequestContext
     *	@param	container	The container
     */
    public View getInstance(RequestContext ctx, ContainerView container, String name) {
        // never need to create a child view.
        return null;
    }
}
