/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * FileListerRelativeTest.java
 * JUnit based test
 *
 * Created on January 29, 2004, 9:56 PM
 */

package com.sun.enterprise.config.backup.util;

import java.io.*;
import java.util.*;
import junit.framework.*;

/**
 *
 * @author Byron Nevins
 */
public class FileListerRelativeTest extends TestCase
{
	
	public FileListerRelativeTest(java.lang.String testName)
	{
		super(testName);
	}
	
	public static Test suite()
	{
		TestSuite suite = new TestSuite(FileListerRelativeTest.class);
		return suite;
	}
	
	/** Test of relativePath method, of class com.sun.enterprise.config.backup.util.FileListerRelative. */
	public void testGetFiles()
	{
		System.out.println("testGetFiles");
		File f = new File("C:/temp");
		FileListerRelative flr = new FileListerRelative(f);
		System.out.println("All the files under " + f + "\n************************\n\n");
		
		long start = System.currentTimeMillis();
		String[] list = flr.getFiles();
		long end = System.currentTimeMillis();
		
		for(int i = 0; i < list.length; i++)
			System.out.println(list[i]);
		
		System.out.println("Total number of files: " + list.length + ",  Time in msec: " + (end - start));
	}
		
	public static void main(java.lang.String[] args)
	{
		junit.textui.TestRunner.run(suite());
	}
	
	// Add test methods here, they have to start with 'test' name.
	// for example:
	// public void testHello() {}
	
	
}
