/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin/mbeanapi-impl/src/java/com/sun/enterprise/management/config/EJBTimerServiceConfigFactory.java,v 1.7 2006/03/09 20:30:38 llc Exp $
 * $Revision: 1.7 $
 * $Date: 2006/03/09 20:30:38 $
 */


package com.sun.enterprise.management.config;

import java.util.Map;
import java.util.Set;
import java.util.Collections;

import javax.management.ObjectName;
import javax.management.AttributeList;


import com.sun.appserv.management.base.XTypes;
import com.sun.enterprise.management.support.Delegate;
import com.sun.enterprise.management.config.AMXConfigImplBase;
import com.sun.enterprise.management.support.oldconfig.OldEJBContainerConfigMBean;

import com.sun.appserv.management.config.EJBTimerServiceConfigKeys;

import com.sun.appserv.management.util.misc.GSetUtil;


/**
	Configuration for the &lt;ejb-container&gt; element.
 */

public final class EJBTimerServiceConfigFactory  extends ConfigFactory
{
	private final OldEJBContainerConfigMBean	mOldEJBContainerConfigMBean;
		public
	EJBTimerServiceConfigFactory(
		final ConfigFactoryCallback			callbacks)
	{
		super( callbacks );
		
		mOldEJBContainerConfigMBean	=
		    getOldConfigProxies().getOldEJBContainerConfigMBean( getConfigName() );
	}

	private final Set<String>	LEGAL_OPTIONAL_KEYS	= 
		GSetUtil.newUnmodifiableStringSet(
		EJBTimerServiceConfigKeys.MINIMUM_DELIVERY_INTERVAL_IN_MILLIS_KEY,
		EJBTimerServiceConfigKeys.MAX_REDELIVERIES_KEY,
		EJBTimerServiceConfigKeys.TIMER_DATASOURCE_KEY,
		EJBTimerServiceConfigKeys.REDELIVERY_INTERVAL__INTERNAL_IN_MILLIS_KEY );

	
	    protected Set<String>
	getLegalOptionalCreateKeys()
	{
		return( LEGAL_OPTIONAL_KEYS );
	}

		public ObjectName
	create( final Map<String,String> attrs )
	{
		final Map<String,String> params	= initParams( attrs );

		final ObjectName	amxName	= createChild( params );
		
		return( amxName );
	}

	
	/**
	 */
		protected void 
	internalRemove( final ObjectName objectName )
	{
		mOldEJBContainerConfigMBean.removeEjbTimerService();
	}

		protected ObjectName
	createOldChildConfig( final AttributeList attrs )
	{
		return mOldEJBContainerConfigMBean.createEjbTimerService( attrs );
	}

}

