/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.management.config;

import java.util.Set;
import java.util.Collections;

import javax.management.ObjectName;

import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.config.Description;

import com.sun.appserv.management.util.misc.GSetUtil;

import com.sun.appserv.management.config.ResourceConfigKeys;
import com.sun.appserv.management.config.ResourceRefConfig;
import com.sun.appserv.management.config.ResourceRefConfigReferent;

import com.sun.appserv.management.helper.RefHelper;

	
/**
 */

abstract class ResourceFactoryImplBase extends ConfigFactory
{
		public
	ResourceFactoryImplBase( final ConfigFactoryCallback	callbacks )
	{
		super( callbacks );
	}
	
	
	public static final String	RESOURCE_TYPE_KEY			= "ResType";
	public static final String	RESOURCE_ADAPTER_KEY		= "ResAdapter";
	
	
		public final void
	internalRemove( final ObjectName objectName )
	{
		final String	name	= Util.getName( objectName );
		removeByName( name );
    }
    
    protected abstract void	removeByName( final String name );


	private final Set<String>	RESOURCE_DEFAULT_LEGAL_OPTIONAL_KEYS	= 
		GSetUtil.newUnmodifiableStringSet(
		Description.DESCRIPTION_KEY,
		ResourceConfigKeys.ENABLED_KEY
	);
	
	
	/**
		  By default, assume there are no optional keys.
	 */
	    protected Set<String>
	getLegalOptionalCreateKeys()
	{
		return( RESOURCE_DEFAULT_LEGAL_OPTIONAL_KEYS );
	}
	
	    protected Set<ResourceRefConfig>
	findAllRefConfigs(
	    final String j2eeType,
	    final String name )
	{
	    final ResourceRefConfigReferent item    = (ResourceRefConfigReferent)
	        requireItem( j2eeType, name );
	    
	    return RefHelper.findAllRefConfigs( item );
	}
}

