/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/**
*/

package com.sun.enterprise.management.config;

import java.util.Set;
import java.util.Map;
import java.util.HashMap;

import javax.management.ObjectName;
import javax.management.AttributeList;

import com.sun.appserv.management.config.AMXConfig;

import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.base.XTypes;

import com.sun.appserv.management.config.ResourceRefConfig;
import com.sun.appserv.management.config.ResourceConfigKeys;
import com.sun.appserv.management.util.misc.MapUtil;
import com.sun.appserv.management.util.misc.GSetUtil;
import com.sun.appserv.management.util.jmx.JMXUtil;

import com.sun.enterprise.management.support.oldconfig.OldServerMBean;


public class ResourceRefConfigFactory extends ConfigFactory
{
		public
	ResourceRefConfigFactory( final ConfigFactoryCallback	callbacks )
	{
		super( callbacks );
	}

		protected Map<String,String>
	getParamNameOverrides()
	{
		return( MapUtil.newMap( AMXConfig.NAME_KEY, "ref" ) );
	}

	/* WHY is this code doing it this way instead of using the usual facilities? */
		public ObjectName
	create(
		final String referencedResourceName,
	    final Map<String,String> optional)
	{
		final String j2eeType = getFactoryContainer().getJ2EEType();
		final String containerName = getFactoryContainer().getName();

		getOldResourcesMBean().createResourceReference(containerName, true, 
		        referencedResourceName);

		ObjectName pattern = null;
		if( XTypes.STANDALONE_SERVER_CONFIG.equals(j2eeType) )
		{
		    pattern = Util.newObjectNamePattern( "com.sun.appserv", 
		        "type=resource-ref,ref=" + referencedResourceName +
		        ",server=" + containerName);
		}
		else
		{
		    pattern = Util.newObjectNamePattern( "com.sun.appserv", 
		        "type=resource-ref,ref=" + referencedResourceName +
		        ",cluster=" + containerName);
		}

		final Set<ObjectName> oldNames =
		    JMXUtil.queryNames( getCallbacks().getMBeanServer(), pattern, null );
		final ObjectName oldObjectName = GSetUtil.getSingleton( oldNames );

		final ObjectName	amxName	= syncNewAMXMBeanWithOld( oldObjectName );

		return( amxName );
	}

		public ObjectName
	create(final String referencedResourceName)
	{
		return create(referencedResourceName, null);
	}


		public ObjectName
	create(
		final String referencedResourceName, 
	    final boolean enabled)
	{
		final Map<String,String> optionalParams = new HashMap<String,String>();
		optionalParams.put( ResourceConfigKeys.ENABLED_KEY,Boolean.toString(enabled));
		
		return create(referencedResourceName, optionalParams);
	}

		protected void
	internalRemove( final ObjectName objectName )
	{
		final String containerName = getFactoryContainer().getName();

		getOldResourcesMBean().deleteResourceReference( containerName, Util.getName( objectName ));
	}
}








