/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin/mbeanapi-impl/src/java/com/sun/enterprise/management/j2ee/WebModuleImpl.java,v 1.9 2006/03/09 20:30:45 llc Exp $
 * $Revision: 1.9 $
 * $Date: 2006/03/09 20:30:45 $
 */
 
package com.sun.enterprise.management.j2ee;

import java.util.Map;

import javax.management.ObjectName;

import com.sun.appserv.management.j2ee.J2EETypes;

import com.sun.appserv.management.base.XTypes;
import com.sun.appserv.management.base.AMX;
import com.sun.appserv.management.base.Util;

import com.sun.appserv.management.util.misc.MapUtil;
import com.sun.appserv.management.util.misc.CollectionUtil;
import com.sun.appserv.management.util.misc.ExceptionUtil;
import com.sun.appserv.management.util.misc.StringUtil;
import com.sun.appserv.management.util.jmx.AttributeNameMapper;

import com.sun.enterprise.management.support.Delegate;
import com.sun.enterprise.management.support.WebModuleSupport;

import com.sun.appserv.management.j2ee.WebModule;
import com.sun.appserv.management.j2ee.Servlet;

/**
 */
public final class WebModuleImpl extends J2EEModuleImplBase
	// implements WebModule
{
		public
	WebModuleImpl( final Delegate delegate )
	{
		super( delegate );
	}
	
	/**
		MBeans of type j2eeType=WebModule have their virtual server prepended
		to their name. For example, if the virtual server is "__asadmin", the
		name will start with "//__asadmin/".
	 */
		protected String
	getConfigPeerName()
	{
		final String compositeName	= getName();
		
		final String webModuleName	= WebModuleSupport.extractWebModuleName( compositeName );

		return( webModuleName );
	}
	
		public boolean
	isConfigProvider()
	{
		boolean	isConfigProvider	= super.isConfigProvider();
		if ( super.isConfigProvider() && getObjectName() != null )
		{
			final String name	= getConfigPeerName();
			
			/*
				Ugly hack for our System WebModules.
				// context root is being used instead of module name
			 */
			if ( name.length() == 0 || name.equals( "asadmin" ) ||
				name.equals( "web1" ) )
			{
				isConfigProvider	= false;
			}
			
		}
		
		return( isConfigProvider );
	}
	
	    protected WebModule
	getSelfProxy()
	{
	    return (WebModule)getSelf();
	}
	
		public String[]
	getservlets()
	{
	    final Map<String,Servlet>   servlets    = getSelfProxy().getServletMap();
	    
		return( CollectionUtil.toStringArray( Util.toObjectNames( servlets ).values() ) );
	}
	
		public Map
	getServletObjectNameMap()
	{
		return( getContaineeObjectNameMap( J2EETypes.SERVLET ) );
	}
	
		protected String
	getMonitoringPeerJ2EEType()
	{
		return( XTypes.WEB_MODULE_VIRTUAL_SERVER_MONITOR );
	}


		private final String
	deduceModuleName()
	{
		// get the last part of the workDir; it should be the actual module name
		final String	workDir	= getSelfProxy().getWorkDir();
		final int index1	= workDir.lastIndexOf( "/" );
		final int index2	= workDir.lastIndexOf( "\\" );
		final int index	= index1 > index2 ? index1 : index2;
		
		String	result	= null;
		
		if (index > 0 )
		{
			result	= workDir.substring( index + 1, workDir.length() );
		}
		
		return( result );
	}
	 
		protected ObjectName
	queryConfigPeerFailed( final Map<String,String> propsMap )
	{
		final String potentialName	= deduceModuleName();
		propsMap.put( AMX.NAME_KEY, potentialName );
		
		final ObjectName	result	= queryProps( propsMap );
		
		return( result );
	}
	
		protected ObjectName
	queryMonitoringPeerFailed( final Map<String,String> propsMap )
	{
		final String	selfName	= getName();
		
		final String virtualServerName	= WebModuleSupport.extractVirtualServerName( selfName );
		
		ObjectName	result	= null;
		
		final String potentialName	= deduceModuleName();
		if ( potentialName != null )
		{
			final String	name	= WebModuleSupport.formCompositeName( virtualServerName, potentialName );

			propsMap.put( AMX.NAME_KEY, name );
			result	= queryProps( propsMap );
		}
		
		return result;
	}
}
