/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 */

package com.sun.enterprise.management.monitor;

import java.util.Map;

import com.sun.appserv.management.base.XTypes;
import com.sun.enterprise.management.support.Delegate;

import com.sun.appserv.management.monitor.statistics.AltServletStats;

import javax.management.j2ee.statistics.Statistic;
import javax.management.j2ee.statistics.TimeStatistic;
import javax.management.j2ee.statistics.CountStatistic;

import com.sun.appserv.management.util.misc.ArrayUtil;
import com.sun.appserv.management.util.j2ee.J2EEUtil;

import com.sun.appserv.management.j2ee.statistics.TimeStatisticImpl;
import com.sun.appserv.management.j2ee.statistics.CountStatisticImpl;


public class ServletMonitorImpl
	extends MonitoringStatsImplBase
	// implements ServletMonitor
{
		public
	ServletMonitorImpl(Delegate delegate) 
	{
		super( XTypes.SERVLET_MONITOR, delegate );
	}

		protected Class
	getStatsInterface()
	{
		return( AltServletStats.class );
	}
	
		public AltServletStats
	getAltServletStats()
	{
		return( (AltServletStats)getStats() );
	}
	
	
	/**
		[WORKAROUND]
		Underlying MBean supplies extra, non-standard and redundant Statistics;
		make sure expose only those we advertise in AltServletStats (unit tests
		will fail otherwise).
		
		Does this still need to be done in 9.0?
	 */
		protected final Statistic[]
	getStatisticsFromDelegate( final Delegate d)
	{
		final Statistic[]	fromSuper	= super.getStatisticsFromDelegate( d );
		
		final Map<String,Statistic>	m	= J2EEUtil.statisticsToMap( fromSuper );

		final Statistic[]	result	= new Statistic[ 6 ];
		
		result[ 0 ]	= (Statistic)m.get( "ServiceTime" );  // from ServletStats
		result[ 1 ]	= (Statistic)m.get( "ErrorCount" );  // from AltServletStats
		result[ 2 ]	= (Statistic)m.get( "RequestCount" );  // from AltServletStats
		result[ 3 ]	= (Statistic)m.get( "ProcessingTime" );  // from AltServletStats
		result[ 4 ]	= (Statistic)m.get( "MaxTime" );  // from AltServletStats
		result[ 5 ]	= (Statistic)m.get( "ServiceTime" );  // from AltServletStats
		
		return result;
	}
	
	

	
}
