/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.management.support;

import java.util.Hashtable;
import java.util.Map;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.AttributeChangeNotification;

import static com.sun.appserv.management.base.AMX.J2EE_TYPE_KEY;
import static com.sun.appserv.management.base.AMX.NAME_KEY;
import static com.sun.appserv.management.base.AMX.JMX_DOMAIN;
import static com.sun.appserv.management.base.XTypes.LOAD_BALANCER;
import static com.sun.appserv.management.base.XTypes.LOAD_BALANCER_CONFIG;
import static com.sun.appserv.management.base.XTypes.LOAD_BALANCER_MONITOR;
import static com.sun.appserv.management.base.XTypes.LB_CONFIG;

import com.sun.enterprise.management.support.AMXServerLogger;
import com.sun.enterprise.management.support.AMXMBeanRootLogger;

import com.sun.appserv.management.config.LoadBalancerConfig;
import com.sun.appserv.management.config.LBConfig;
import com.sun.appserv.management.client.ProxyFactory;
import com.sun.appserv.management.monitor.LoadBalancerMonitor;  
import com.sun.appserv.management.base.Util;

/**
 * Utilities to help the DeregisterationHelpers that are 
 * invoked in postDeRegister() methods of the config MBeans
 */
public final class LBDeregistrationUtil {

    private MBeanServer mbs  = null;
    private Map<String, NotificationListener> mLBConfigListenersMap = null;
    private static LBDeregistrationUtil mUtil = null;
            
    private LBDeregistrationUtil(MBeanServer mbs) {
        mLBConfigListenersMap = new Hashtable<String, NotificationListener>();
        this.mbs=mbs;
    } 
    
    public static LBDeregistrationUtil getInstance(MBeanServer mbs) {
        if (mUtil == null) mUtil = new LBDeregistrationUtil(mbs);
        return mUtil;
    }
    
    public LoadBalancerMonitor fetchLBMonitoringRoot(
        String loadBalancerName) throws JMException {

        ObjectName loadBalancerMonitorObjName = 
            new ObjectName(JMX_DOMAIN + ":" + J2EE_TYPE_KEY + "=" + 
                LOAD_BALANCER_MONITOR + "," + NAME_KEY + "=" + loadBalancerName);
        LoadBalancerMonitor loadBalancerMonitor = 
            ProxyFactory.getInstance(mbs).getProxy(loadBalancerMonitorObjName, LoadBalancerMonitor.class);

        return loadBalancerMonitor;
    }      
    
    public void addLBConfigListener(String loadBalancerName, 
        NotificationListener nl, LBConfig lbConfig) {
        lbConfig.addNotificationListener(nl, null, null);
        mLBConfigListenersMap.put(loadBalancerName, nl);
    }

    public void removeLBConfigListener(String loadBalancerName, LBConfig lbConfig)
        throws JMException {
        lbConfig.removeNotificationListener(
            (NotificationListener)mLBConfigListenersMap.get(loadBalancerName));
        mLBConfigListenersMap.remove(loadBalancerName);
    }
}