/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */
package com.sun.enterprise.management.support;


import javax.management.ObjectName;

import com.sun.appserv.management.util.misc.StringUtil;
import com.sun.appserv.management.util.jmx.JMXUtil;

/**
 */
public final class WebModuleSupport
{
	private 	WebModuleSupport()	{}
	
	/**
		Used to prefix a virtual server name for a j2eeType=WebModule
	 */
	public static final String	VIRTUAL_SERVER_PREFIX	= "//";
	
	/**
		Used to terminate a virtual server name for a j2eeType=WebModule
	 */
	public static final String	VIRTUAL_SERVER_DELIM	= "/";
	
		public static boolean
	isLegalVirtualServerName( final String candidate )
	{
		return (! candidate.startsWith( VIRTUAL_SERVER_PREFIX ) ) &&
			( candidate.indexOf( VIRTUAL_SERVER_DELIM ) < 0 );
	}
	
		public static String
	formCompositeName(
		final String	virtualServerName,
		final String	webModuleName )
	{
		return VIRTUAL_SERVER_PREFIX + virtualServerName + VIRTUAL_SERVER_DELIM + webModuleName;
	}
	
	
	/**
		WebModule names are of the form //<virtual-server-name>/<web-module-name>.
		Extract the virtual-server-name portion
		@see #extractWebModuleName
	 */
		public static String
	extractVirtualServerName( final String compositeName )
	{
		if ( ! compositeName.startsWith( VIRTUAL_SERVER_PREFIX ) )
		{
			throw new IllegalArgumentException( compositeName );
		}
		
		final String temp	=
			StringUtil.stripPrefix( compositeName, VIRTUAL_SERVER_PREFIX );
		final int	delimIdx	= temp.indexOf( VIRTUAL_SERVER_DELIM );
		if ( delimIdx < 0 )
		{
		    throw new IllegalArgumentException( compositeName );
		}
		
		final String virtualServerName	= temp.substring( 0, delimIdx );
		
		return virtualServerName;
	}
	
	/**
		WebModule names are of the form //<virtual-server-name>/<web-module-name>.
		Extract the web-module-name portion
		@see #extractVirtualServerName
	 */
		public static String
	extractWebModuleName( final String compositeName )
	{
	    final String virtualServerName  = extractVirtualServerName( compositeName );
	    
		final String prefix	=
			VIRTUAL_SERVER_PREFIX + virtualServerName + VIRTUAL_SERVER_DELIM;
	
	    String  name    = compositeName.substring( prefix.length(), compositeName.length() );
		if ( name.length() == 0 )
		{
		    name    = virtualServerName + ".default";
		}
		
		return name;
	}

		public static String
	getWebModuleName( final ObjectName	oldObjectName )
	{
		final String webModule			    = oldObjectName.getKeyProperty( "web-module" );
		final String standaloneWebModule	= oldObjectName.getKeyProperty( "standalone-web-module" );
		
		String	webModuleName   = null;
		if ( standaloneWebModule != null )
		{
		    webModuleName   = extractWebModuleName( standaloneWebModule );
		}
		else if ( webModule != null )
		{
		    webModuleName   = extractWebModuleName( webModule );
		}
		else
		{
		    throw new IllegalArgumentException( JMXUtil.toString( oldObjectName ) );
		}
		
		return( webModuleName );
	}
	
	/** the category=monitor,type=web-module name is {@link #JWS_APP_CLIENTS_WEB_MODULE_MONITOR_NAME} */
	public static final String JWS_APP_CLIENTS_WEB_MODULE_NAME  = "//server/__JWSappclients";
	
	/** the category=runtime,type=WebModule name is {@link #JWS_APP_CLIENTS_WEB_MODULE_NAME} */
	public static final String JWS_APP_CLIENTS_WEB_MODULE_MONITOR_NAME  = "//server/sys";
	
	//
}

