/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.management.config;

import java.util.Map;

import com.sun.appserv.management.base.Container;
import com.sun.appserv.management.base.XTypes;

import com.sun.appserv.management.config.AMXConfig;
import com.sun.appserv.management.config.ClusterConfig;
import com.sun.appserv.management.config.DomainConfig;


import com.sun.enterprise.management.AMXTestBase;
import com.sun.enterprise.management.Capabilities;
import com.sun.enterprise.management.ClusterSupportRequired;

/**
	Test the creation/removal of ClusterConfig
 */
public final class ClusterConfigTest extends ConfigMgrTestBase
    implements ClusterSupportRequired
{
		public
	ClusterConfigTest ()
	{
	    if ( checkNotOffline( "ensureDefaultInstance" ) )
	    {
	        ensureDefaultInstance( getDomainConfig() );
	    }
	}
	
        public static String
    getDefaultInstanceName()
    {
        return getDefaultInstanceName( "test-cluster" );
    }
    
		public static ClusterConfig
	ensureDefaultInstance( final DomainConfig domainConfig )
	{
	    ClusterConfig   result  =
	        domainConfig.getClusterConfigMap().get( getDefaultInstanceName() );
	    
	    if ( result == null )
	    {
	        result  = domainConfig.createClusterConfig(
	                    getDefaultInstanceName(), null, null );
	    }
	    
	    return result;
	}
	
		protected Container
	getProgenyContainer()
	{
		return getDomainConfig();
	}

		protected String
	getProgenyJ2EEType()
	{
		return XTypes.CLUSTER_CONFIG;
	}


		protected void
	removeProgeny( final String name )
	{
		getDomainConfig().removeClusterConfig( name );
	}
	

		protected final AMXConfig
	createProgeny(
		final String name,
		final Map<String,String> options )
	{
	    assert( name != null && name.length() >= 1 );
	    return getDomainConfig().createClusterConfig( name, null, options );
	}
	
		public void
	testCreateWithIllegalConfig()
	{
		try
		{
			getDomainConfig().createClusterConfig( "dummy-cluster-1", "no such config", null );
			failure( "expecting failure creating cluster with illegal config name" );
			
			getDomainConfig().createClusterConfig( "dummy-cluster-2", "server-config", null );
			failure( "expecting failure creating cluster with name 'server-config'" );
			
			getDomainConfig().createClusterConfig( "dummy-cluster-2", "default-config", null );
			failure( "expecting failure creating name 'default-config'" );
		}
		catch( Exception e )
		{
			// good
		}
	}
}








