/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.management.config;

import com.sun.appserv.management.base.Util;

import com.sun.appserv.management.config.ResourceConfig;
import com.sun.appserv.management.config.StandaloneServerConfig;

import com.sun.appserv.management.util.misc.ExceptionUtil;

import com.sun.enterprise.management.AMXTestBase;

/**
 */
public abstract class ResourceConfigTestBase extends ConfigMgrTestBase
{
		protected
	ResourceConfigTestBase()
	{
		super();
		
		StandaloneServerConfigTest.ensureDefaultInstance( getDomainRoot() );
	}
	
	    protected void
	addReference( final ResourceConfig rc )
	{
	    final StandaloneServerConfig    server  =
	        StandaloneServerConfigTest.ensureDefaultInstance( getDomainRoot() );
	    assert server != null;
	    
	    if ( server.getResourceRefConfigMap().get( rc.getName() ) != null )
	    {
	        warning( "ResourceRefConfig already exists for: " + rc.getName() );
	    }
	    else
	    {
    	    try
    	    {
    	        server.createResourceRefConfig( rc.getName(), false );
    	    }
    	    catch( Exception e )
    	    {
    	        final Throwable rootCause   = ExceptionUtil.getRootCause( e );
    	        
    	        warning( "Couldn't add RefConfig to: " + Util.getObjectName( rc ) );
    	    }
	    }
	    
	    assert server.getResourceRefConfigMap().get( rc.getName() ) != null;
	}
	

}


