/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.management.ext.logging;

import java.util.Map;
import java.util.Date;
import java.util.logging.Level;

import javax.management.openmbean.CompositeData;
import javax.management.openmbean.OpenDataException;

import com.sun.appserv.management.ext.logging.LogQueryResult;
import com.sun.appserv.management.ext.logging.LogQueryResultImpl;
import com.sun.appserv.management.ext.logging.LogQueryEntryImpl;


import com.sun.enterprise.management.Capabilities;

/**
 */
public final class LogQueryResultImplTest extends junit.framework.TestCase
{
		public
	LogQueryResultImplTest( )
	{
	}
	
	private static final String[] FIELD_NAMES  = new String[]
	{
	    "#",
	    "DATE",
	    "LEVEL",
	    "PRODUCT NAME",
	    "MODULE",
	    "MESSAGE",
	    "MESSAGE ID",
	    "NAME VALUE PAIRS",
	};
	
	    public LogQueryResultImpl
    createDummy()
    {
        final LogQueryEntryImpl entry   = LogQueryEntryImplTest.createDummy();
        
        final LogQueryResultImpl impl   =
            new LogQueryResultImpl( FIELD_NAMES, new LogQueryEntryImpl[] { entry } );
       
       return impl;
    }
    
	    public void
    testCreate()
    {
        createDummy().toString().hashCode(); // non-null check
        
        assertEquals( createDummy(), createDummy() );
    }
    
    
        public void
    testEquals()
    {
        final LogQueryResult d   = createDummy();
        
        assertEquals( d, d );
        
        final LogQueryResult dCopy  =
            new LogQueryResultImpl( d.getFieldNames(), d.getEntries() );
       
        assertEquals( d, dCopy );
        assertEquals( dCopy, d );
    }
    
	    public void
    testGetters()
        throws OpenDataException
    {
        final LogQueryResultImpl d   = createDummy();
        
        d.getFieldNames();
        d.getEntries();
       // d.getCompositeType();
        //d.asCompositeData();
    }
    
    /*
	    public void
    testCompositeData()
        throws OpenDataException
    {
        final LogQueryResultImpl d   = createDummy();
        
        final CompositeData       data    = d.asCompositeData();
        final LogQueryResultImpl  copy = new LogQueryResultImpl( data );
        
        assertEquals( d, copy );
    }
    */
	
}









