/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
/*
 * EEBaseConfigMBean.java
 *
 * Created on September 18, 2003, 11:49 AM
 */

package com.sun.enterprise.admin.configbeans;

import com.sun.enterprise.admin.config.BaseConfigMBean;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.server.ServerContextImpl;

import com.sun.enterprise.admin.AdminContext;
import com.sun.enterprise.admin.server.core.AdminService;

import javax.management.MBeanException;

/**
 *
 * @author  kebbs
 */
public class BaseConfigBean {        
       
    public static final boolean OVERWRITE = BaseConfigMBean.OVERWRITE;
    
    private ConfigContext _configContext;
    
    public BaseConfigBean(ConfigContext configContext)
    {
        _configContext = configContext;
    }       
    
    //FIXTHIS: This needs to be refactored out since it used in a number of places when
    //we make the decision whether this is the correct approach.
    /**
     * Persist config changes to disk. Clear all config changes (so that no notification will be
     * fired) by the ConfigInterceptor. Overlay the runtime config context with the modified
     * admin context.
     */
    public static void flushAll(ConfigContext ctx) throws ConfigException
    {       
        ctx.flush(OVERWRITE);
        ctx.resetConfigChangeList();
        //((ServerContextImpl)ApplicationServer.getServerContext()).setConfigContext(ctx);        
    }
    
    //FIXTHIS: This needs to be refactored out since it used in a number of places when
    //we make the decision whether this is the correct approach.
    protected void flushAll() throws ConfigException
    {
        flushAll(getConfigContext());
    }
    
    //We must subclass this method, because the base case seems to return a null config context if 
    //the mbean does not have a corresponding xpath (or something). The properties MBean seems
    //to have this problem.
    protected ConfigContext getConfigContext()
    {
        return _configContext;
    }
}
