/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin/mbeans/src/java/com/sun/enterprise/admin/dottedname/DottedNameFactory.java,v 1.3 2005/12/25 03:42:02 tcfujii Exp $
 * $Revision: 1.3 $
 * $Date: 2005/12/25 03:42:02 $
 */
package com.sun.enterprise.admin.dottedname;

import java.util.HashMap;

import com.sun.enterprise.admin.util.ClassUtil;

/*
	This class caches dotted name strings against their DottedName counterparts.
	
	This helps avoid the fairly expensive parse of the string, as well as minimizing
	creation of new objects.
 */
public final class DottedNameFactory
{
	static final Factory	sImpl	= newInstance();
	
	public interface Factory
	{
		//public DottedName	lookup( final String dottedNameString );
		public DottedName	get( final String dottedNameString );
		public void			clear();
		public void			add( final DottedName dn );
	}
	
	
		private
	DottedNameFactory()
	{
		// disallow instantiation outside newInstance()
	}
	
		public static Factory
	newInstance()
	{
		return( new Impl() );
	}
	
		public static Factory
	getInstance()
	{
		return( sImpl );
	}
		
	
	/* implements the cache */
	private static final class Impl implements Factory
	{
		final HashMap	mMapping;
		
			public
		Impl()
		{
			// disallow outside instantiation
			mMapping	= new HashMap( 300 );
		}
		
			public synchronized void
		add( final DottedName dottedName )
		{
			mMapping.put( dottedName.toString(), dottedName );
		}
		
			public synchronized void
		clear()
		{
			mMapping.clear();
		}
		
		
			public DottedName
		get( final String dottedNameString )
		{
			DottedName	dn	= lookup( dottedNameString );
			
			if ( dn == null )
			{
				dn	= new DottedName( dottedNameString );
				add( dn );
			}
			
			return( dn );
		}
		
		
			synchronized DottedName
		lookup( final String dottedNameString )
		{
			final DottedName	dn	= (DottedName)mMapping.get( dottedNameString );
			
			assert( dn == null || dn.toString().equals( dottedNameString ) );
			
			return( dn );
		}

	}
}



