/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.admin.mbeans;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.MalformedObjectNameException;
import javax.management.MBeanServerInvocationHandler;

import com.sun.enterprise.admin.common.MBeanServerFactory;
import com.sun.enterprise.server.ApplicationServer;

import com.sun.appserv.management.client.ProxyFactory;

import java.util.logging.Level;
import java.util.logging.Logger;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.admin.common.constant.AdminConstants;

/**
 * Helper class for setting server status in DomianStatusMBean
 *
 * @author Sreenivas Munnangi
 */

public class DomainStatusHelper {

    // vars

    private static final Logger sLogger =
        Logger.getLogger(AdminConstants.kLoggerName);

    private static final StringManager localStrings =
        StringManager.getManager( DomainStatusHelper.class );

    private static final Class[] DOMAIN_STATUS_INTERFACES =
	new Class[] { DomainStatusMBean.class };


    // default constructor
    public DomainStatusHelper() {
    }

    public DomainStatusHelper(String serverName) {
    }

    public void setstate (String serverName, int state) {
	sLogger.log(Level.FINE, "DomainStatusHelper setstate for " + serverName);
	try {
		getDomainStatus().setstate(serverName, new Integer(state));
	} catch (Exception e) {
		sLogger.log(Level.WARNING, 
			"DomainStatusHelper setstate exception for server " +
			serverName, e);
	}
    }

    public int getstate (String serverName) throws Exception {
	sLogger.log(Level.FINE, "DomainStatusHelper getstate for " + serverName);
	return (getDomainStatus().getstate(serverName));
    }

    protected DomainStatusMBean getDomainStatus() {
	MBeanServer mbs = MBeanServerFactory.getMBeanServer();
	ObjectName  on  = null;
	try {
		on  = getDomainStatusObjectName();
	} catch (MalformedObjectNameException mone) {
		sLogger.log(Level.WARNING, 
			"DomainStatusHelper getDomainStatus ObjectName exception", mone);
	}
	DomainStatusMBean domainStatus = null;
	try {
		domainStatus = 
			(DomainStatusMBean)MBeanServerInvocationHandler.newProxyInstance(
				mbs, on, DomainStatusMBean.class, false );
	} catch (Exception e) {
		sLogger.log(Level.WARNING, 
			"DomainStatusHelper getDomainStatus io exception", e);
	}
	return(domainStatus);
    }

    public static ObjectName getDomainStatusObjectName() 
	throws MalformedObjectNameException {

	ObjectName on = new ObjectName(
		ApplicationServer.getServerContext().getDefaultDomainName() + ":" +
		DomainStatusMBean.DOMAIN_STATUS_PROPS);
	return on;
    }

    public static ObjectName getServersConfigObjectName() 
	throws MalformedObjectNameException {

	ObjectName on = new ObjectName(
		ApplicationServer.getServerContext().getDefaultDomainName() + ":" +
		"type=servers,category=config");
	return on;
    }


}
