/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.management.model;

import java.util.*;
import javax.management.*;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.WebService;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.management.util.J2EEModuleCallBack;

public class J2EEApplicationMdl extends J2EEDeployedObjectMdl {
    
    private static String MANAGED_OBJECT_TYPE = "J2EEApplication";
    private String appName = null;
    private boolean hasWebServices=false;
    private String[] endpointAddresses = null;
    
    public J2EEApplicationMdl(J2EEModuleCallBack module, Application app) {
	super(module);
        
        appName = module.getParentName();
	if (app==null) {
	    return;
	}
	Set webServices = app.getWebServiceDescriptors();
	if (webServices.size()>0) {
	    hasWebServices = true;
	    Vector endpointList = new Vector();
	    for (Iterator itr = webServices.iterator();itr.hasNext();) {
		WebService webService = (WebService) itr.next();
		for (Iterator endpoints = webService.getWebServicesDescriptor().getEndpoints().iterator();
			endpoints.hasNext();) {
		    WebServiceEndpoint wse = (WebServiceEndpoint) endpoints.next();
		    endpointList.add(wse.getEndpointAddressUri());
		}
	    }
	    endpointAddresses = new String[endpointList.size()];
	    endpointList.copyInto(endpointAddresses);
	}	    
    }
    
    public String [] getmodules() {

        Set appMods = findNames("j2eeType=EJBModule,J2EEServer=" + getJ2EEServer()+",J2EEApplication="+this.appName);
        appMods.addAll(findNames("j2eeType=WebModule,J2EEServer=" + getJ2EEServer()+",J2EEApplication="+this.appName));
        appMods.addAll(findNames("j2eeType=ResourceAdapterModule,J2EEServer=" + getJ2EEServer()+",J2EEApplication="+this.appName));
        appMods.addAll(findNames("j2eeType=AppClientModule,J2EEServer=" + getJ2EEServer()+",J2EEApplication="+this.appName));

        Iterator it = appMods.iterator();
        String [] mods = new String[appMods.size()];
        int i =0;
        while(it.hasNext()) {
            mods[i++] = ((ObjectName)it.next()).toString();
        }
        return mods; 
    }
    
    /**
     * The type of the J2EEManagedObject as specified by JSR77. The class that implements a specific type must override this method and return the appropriate type string.
     */
    public String getj2eeType() {
        return MANAGED_OBJECT_TYPE;
    }
    
    /**
     * The name of the J2EEManagedObject. All managed objects must have a unique name within the context of the management
     * domain. The name must not be null.
     */
    public String getobjectName() {
        Set s = findNames("j2eeType="+getj2eeType()+",name="+this.appName+",J2EEServer="+getJ2EEServer());
        Object [] objs = s.toArray();
        if (objs.length > 0) {
        	String name = ((ObjectName)objs[0]).toString();
        	return name;
        } else {
            return null;
        }
    }
    
    /**
     * @return true if this application implements any webservice endpoint
     */
    public boolean gethasWebServices() {
	return hasWebServices;
    }
 
    /**
     * @return array of endpoint addresses defined for this application
     */
    public String[] getendpointAddresses() {
	return endpointAddresses;
    }
}
