/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.management.model;

import javax.management.*;
import java.util.Set;
import java.util.HashSet;
import javax.management.j2ee.Management;
import javax.management.j2ee.ManagementHome;
import javax.rmi.PortableRemoteObject;
import javax.naming.*;
import java.security.AccessController;
import java.security.PrivilegedAction;

import com.sun.enterprise.management.agent.MEJBUtility;
import com.sun.enterprise.management.util.J2EEModuleUtil;

/**
 * The base class for all Managed Objects
 *
 * @author Hans Hrasna
 */
public abstract class J2EEManagedObjectMdl {
    // name - key attribute for the managed object
    private String name;
    private boolean stateManageable;
    private boolean statisticsProvider;
    private boolean eventProvider;
    private String serverName;

    J2EEManagedObjectMdl(String name,boolean state, boolean statistics, boolean events) {
        this.name = name;
        stateManageable = state;
        statisticsProvider = statistics;
        eventProvider = events;
    }

    J2EEManagedObjectMdl(String name, String serverName,
                         boolean state, boolean statistics, boolean events) {
        this.name = name;
        stateManageable = state;
        statisticsProvider = statistics;
        eventProvider = events;
        this.serverName = serverName;
    }

    // returns the MBeanServer local to this VM
    // creates one if it doesn't exsist yet
    MBeanServer getMBeanServer() {
        java.util.ArrayList servers =
                (java.util.ArrayList) AccessController.doPrivileged(new PrivilegedAction() {
                    public java.lang.Object run() {
                        return MBeanServerFactory.findMBeanServer(null);
                    }
                });
        if (servers.isEmpty()) {
            return (MBeanServer) AccessController.doPrivileged(new PrivilegedAction() {
                    public java.lang.Object run() {
                        return MBeanServerFactory.createMBeanServer();
                    }
                });
        } else {
            return (MBeanServer)servers.get(0);
        }
    }

    MEJBUtility getMEJBUtility(){
        //FIXME
        //return com.sun.enterprise.Switch.getSwitch().getManagementObjectManager().getMEJBUtility();
        return MEJBUtility.getMEJBUtility();
    }
    
    Management getMEJB() {
        Management mejb=null;
        try {
            Context ic = new InitialContext();
            String ejbName = System.getProperty("mejb.name","ejb/mgmt/MEJB");
            java.lang.Object objref = ic.lookup(ejbName);
            ManagementHome home = (ManagementHome)PortableRemoteObject.narrow(objref, ManagementHome.class);
            mejb = home.create();
        } catch (Exception ex) {
            ex.printStackTrace();
        }
        return mejb;
    }
      
    public Set findNames(String keys) {
        return J2EEModuleUtil.findNames(keys);
    }


    /**
     * The type of the J2EEManagedObject as specified by JSR77. The class that implements a specific type must override this
     * method and return the appropriate type string.
     */
    public abstract String getj2eeType();

    /**
     * The name of the J2EEManagedObject. All managed objects must have a unique name within the context of the management
     * domain. The name must not be null.
     */
    public abstract String getobjectName();

    /**
     * If true, indicates that this managed object implements the StateManageable interface and is state manageable. If false,
     * the managed object does not support state management.
     */
    public boolean isstateManageable() {
        return stateManageable;
    }

    /**
     * If true, indicates that the managed object supports performance statistics and therefore implements the
     * StatisticsProvider model. If false, the J2EEManagedObject does not support performance statistics
     */
    public boolean isstatisticsProvider() {
        return statisticsProvider;
    }

    /**
     * If true, indicates that the managed object provides event notification about events that occur on that object. All
     * managed objects that support state management are by default event providers. If the stateManageable attribute for this
     * managed object is true then the eventProvider attribute must also be true.
     */
    public boolean iseventProvider() {
        return eventProvider;
    }

    /** Accessor method for the parent key */
    public String getJ2EEServer() {
        if (serverName != null) {
                return serverName;
        } else {
                return "server1";
        }
    }
    /** Accessor method for the parent key */
    public String getname(){
        return this.name;
    }
}
