/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/* StatisticWorkaround.java
 * $Id: StatisticWorkaround.java,v 1.3 2005/12/25 03:43:35 tcfujii Exp $
 * $Revision: 1.3 $
 * $Date: 2005/12/25 03:43:35 $
 * Indentation Information:
 * 0. Please (try to) preserve these settings.
 * 1. Tabs are preferred over spaces.
 * 2. In vi/vim -
 *		:set tabstop=4 :set shiftwidth=4 :set softtabstop=4
 * 3. In S1 Studio -
 *		1. Tools->Options->Editor Settings->Java Editor->Tab Size = 4
 *		2. Tools->Options->Indentation Engines->Java Indentation Engine->Expand Tabs to Spaces = False.
 *		3. Tools->Options->Indentation Engines->Java Indentation Engine->Number of Spaces per Tab = 4.
 */

package com.sun.enterprise.admin.monitor.registry.spi;
import javax.management.j2ee.statistics.Statistic;
import com.sun.enterprise.admin.monitor.stats.*;
import com.sun.enterprise.admin.common.constant.AdminConstants;
import java.util.logging.Logger;

/** This class is a workaround for returning the statistic descriptions. Please see bug 5045413. 
	This is a best case effort and in general not expected to be accurate.
	We should revisit this in AS 8.2.
	@since AS 8.1
	@author Kedar.Mhaswade@Sun.Com
*/

final class StatisticWorkaround {
	private static final StatsDescriptionHelper helper = new StatsDescriptionHelper(); 
	private static Logger logger = Logger.getLogger(AdminConstants.kLoggerName);
	static final Statistic[] populateDescriptions(final Statistic[] from) {
		if (from == null) {
			throw new IllegalArgumentException("null arg");	
		}
		final int length = from.length;
		final Statistic[] to = new Statistic[length];
		for (int i = 0 ; i < length ; i++) {
			final Statistic as = from[i];
			final String name = as.getName();
			final String desc = helper.getDescription(name);
			if (StatsDescriptionHelper.NO_DESCRIPTION_AVAILABLE.equals(desc)) {
				//Localized Description was not available, do nothing
				to[i] = from[i];
			}
			else {
                        	attemptSettingDescription(as, desc);
				to[i] = as;
			}
		}
		return ( to );
	}
	private static void attemptSettingDescription(final Statistic s, final String nd) {
		if (s instanceof StatisticImpl) {
			((StatisticImpl)s).setDescription(nd);
			logger.finest("New Description was set: " + nd);
		}
		else if (s instanceof AverageRangeStatisticImpl) {
			((AverageRangeStatisticImpl)s).setDescription(nd);
			logger.finest("New Description was set: " + nd);
		}
		else if (s instanceof MutableBoundedRangeStatisticImpl) {
			((MutableBoundedRangeStatisticImpl)s).setDescription(nd);
			logger.finest("New Description was set: " + nd);
		}
		else if (s instanceof MutableCountStatisticImpl) {
			((MutableCountStatisticImpl)s).setDescription(nd);
			logger.finest("New Description was set: " + nd);
		}
		else if (s instanceof MutableTimeStatisticImpl) {
			((MutableTimeStatisticImpl)s).setDescription(nd);
			logger.finest("New Description was set: " + nd);
		}
	}
}
