/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.config.serverbeans.validation;

import org.xml.sax.ContentHandler;
import org.xml.sax.XMLReader;
import org.xml.sax.InputSource;
import com.sun.org.apache.xml.internal.serializer.ToXMLStream;
import java.io.OutputStream;
import org.xml.sax.EntityResolver;
import java.io.FileOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.IOException;
import org.xml.sax.SAXException;



public class Flatten
{
    public static void main(String [] args) throws Exception {

        String input = null;
        OutputStream output = System.out;
        EntityResolver entityResolver = null;
        
        if ( args.length < 1 || 5 < args.length){
            System.err.println("Flatten [-out output-file] [-dtd dtd] input ");
        }

        for (int i = 0; i < args.length; i++){
            if (args[i].equals("-out")){
                output = new FileOutputStream(new File(args[++i]));
                break;
            }
            if (args[i].equals("-dtd")){
                entityResolver = new MyEntityResolver(args[++i]);
                break;
            }
            input = args[i];
        }

    
        

        VariableResolver vr = new VariableResolver();
        if (null != entityResolver){
            vr.setEntityResolver(entityResolver);
        }
        
//         vr.setParent(getXmlReader());
        vr.setContentHandler(getContentHandler(output));
        vr.parse(new InputSource(input));
    }

    private static XMLReader getXmlReader() throws Exception {
        return XMLReaderFactory.newInstance(System.err);
    }

    private static ContentHandler getContentHandler(OutputStream o) throws Exception {
        ToXMLStream xml = new ToXMLStream();
        xml.setOutputStream(o);
        xml.setOmitXMLDeclaration(true);
        return xml.asContentHandler();
    }

    private static class MyEntityResolver implements EntityResolver
    {
        private String myDtd = "";

        MyEntityResolver(){}
        
        MyEntityResolver(String dtd){
            myDtd = dtd;
        }
        
        public InputSource resolveEntity(java.lang.String publicId, java.lang.String systemId)
            throws IOException, SAXException{
            if (null != publicId && publicId.equals("-//Sun Microsystems Inc.//DTD Application Server 8.0 Domain//EN")) {
                final InputStream is = getClass().getResourceAsStream(myDtd);
                return (null != is ) ? new InputSource(is) : null;
            } else {
                return null;
            }
        }
    }

}
