/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.admin.wsmgmt.repository.spi;

/**
 * This is the mechanism to provide web service information for a given module.  
 * A WebServiceInfoProvider implementation is a class that extends the 
 * WebServiceInfoProvider abstract class. Some WebServiceInfoProvider can deal
 * with ejb and web module. Some only deal with web modules.
 * <br>
 */
public interface WebServiceInfo {

    /**
     * Returns the name of the WebService.
     *
     * @return fully qualified name of this WebService
     */
    public String getName();

    /**
     * Returns the relative URI of this endpoint.
     *
     * @return the uri string
     */
    public String getEndpointUri();

    /**
     * Returns the name of the application or stand alone module that has 
     * this web service. 
     *
     * @return the Application Id
     */
    public String getAppId();

    /**
     * Returns true if this web service belongs to a stand alone module.
     *
     * @return true, if this web service belongs to a stand alone module
     */
    public boolean isAppStandAloneModule();
   
    /**
     * Returns the module name within a EAR or null if it is a stand alone 
     * module. 
     *
     * @return the bundle name
     */
    public String getBundleName();

    /**
     * Returns the implementation type of this web service.
     *
     * @return either "EJB" or "SERVLET"
     */
    public String getServiceImplType();

    /**
     * Returns the implementation Ejb or Servlet name of this web service.
     *
     * @return the Ejb or Servlet name
     */
    public String getServiceImplName();

    /**
     * Returns the implementation Ejb or Servlet class name of this web service.
     *
     * @return the Ejb or Servlet class name
     */
    public String getServiceImplClass();

    /**
     * Returns the WSDL file location. 
     *
     * @return the WSDL file location
     */
    public String getWSDLFileLocation();
     
    /**
     * Returns the webservices.xml file location.
     *
     * @return the webservices file location
     */ 
    public String getWebservicesFileLocation();
 
    /**
     * Returns the mapping file location. 
     *
     * @return the mapping file location
     */
    public String getMappingFileLocation();

    /**
     * Returns the descriptor locations. The descriptors include WSDL, 
     * webservices.xml and mapping file. If the alt WSDL location is specified
     * in the archive, the overridden (correct) WSDL file location is returned.
     *
     * @return the descriptor locations
     */
    public String[] getDescriptorLocations();
}
