/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.jbi.serviceengine.bridge;

import com.sun.enterprise.jbi.serviceengine.comm.MessageProcessor;
import com.sun.enterprise.jbi.serviceengine.core.Bridge;
import com.sun.enterprise.jbi.serviceengine.core.EndpointRegistry;
import com.sun.enterprise.jbi.serviceengine.core.ServiceEngineEndpoint;
import com.sun.enterprise.webservice.ServiceEngineRtObjectFactory;
import com.sun.enterprise.webservice.spi.DefaultServiceDelegateFactory;
import javax.jbi.messaging.MessageExchange;

/**
 * Bridge is initialized during server startup.
 * @author Manisha Umbarje
 */
public class AppServerBridge implements Bridge{
    
    /** Creates a new instance of Bridge */
    public AppServerBridge() {
    }
    
    public void initialize() {
        ServiceEngineRtObjectFactory.getInstance().
                setFacade(ServiceEngineFacadeImpl.getInstance());
        
        //Instantiates Endpoint Helper
        EndpointHelper.getInstance().initialize();
        DefaultServiceDelegateFactory.getFactory().addListener(new ServiceCreationListenerImpl());
    }
    
    public MessageProcessor getMessageProcessor(MessageExchange me) {
        ServiceEngineEndpoint seEndpoint = 
                EndpointRegistry.getInstance().get(
                me.getEndpoint().getServiceName(),
                me.getEndpoint().getEndpointName());
        if(seEndpoint.isJAXWSEndpoint())
            return new JAXWSMessageProcessor();
        else
            return new JAXRPCMessageProcessor();
    }
        
    public void destroy() {
        EndpointHelper.getInstance().destroy();
    }
}
