/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.jbi.serviceengine.work;

import com.sun.enterprise.jbi.serviceengine.comm.MessageAcceptor;
import com.sun.enterprise.jbi.serviceengine.ServiceEngineException;


/**
 * Work Manager interface for JBI Service Engine.
 *
 * @author Binod PG
 */ 
public interface WorkManager {

    /**
     * Set the name of threadpool used by this work manager.
     */
    public void setPoolName(String poolName); 

    /**
     * Return the name of threadpool used by this work manager.
     */
    public String getPoolName();

    /**
     * Submit a work to the queue of thread pool.
     */
    public void submitWork(OneWork work);

    /**
     * Start the acceptor thread of the work manager.
     */
    public void startAcceptor() throws ServiceEngineException ;

    /**
     * Stop the activities of the work manager.
     */
    public void stop();

    /**
     * Retrieve the MessageAcceptor object in use by this work
     * manager.
     */
    public MessageAcceptor getMessageAcceptor();

}
