/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * ConfigRegistry.java
 *
 * Created on January 20, 2004, 11:00 AM
 */

package com.sun.enterprise.config;

import com.sun.enterprise.config.impl.ConfigContextImpl;

/**
 *
 * @author  sridatta
 */
public class ConfigRegistry {
    
    /** Creates a new instance of ConfigRegistry */
    public ConfigRegistry() {
    }
    
    private static ThreadLocal _threadLocalConfigContext = 
                            new ThreadLocal();

    public static ConfigContext getConfigContextFromThreadLocal() {
        return (ConfigContext)_threadLocalConfigContext.get();
    }

    public static void setConfigContextInThreadLocal(ConfigContext ctx) {

        try {
            ((ConfigContextImpl)ctx).setXPathInAllBeans();
        } catch (ConfigException ce) {
            // ignore
        }
        _threadLocalConfigContext.set(ctx);
    }
}
