/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.deployment;

import java.util.*;

/**
 * This class contains the deployment extensions element for a particular
 * xml node. It can contains sub elements (other ExtensionElementDescriptor 
 * instances) or final leafs like attribute or string elements.
 *
 * @author Jerome Dochez
 */
public class ExtensionElementDescriptor extends Descriptor implements Observer {
    
    private List elementNames;
    private Map elementValues;
    private DynamicAttributesDescriptor attributes;
    
    /**
     * @return the value holder for all sub elements of 
     * this deployment extension element
     */
    public Iterator getElementNames() {
        if (elementNames!=null) {
            return elementNames.iterator();
        }
        return null;
    }
    
    public void addElement(String elementName, Object value) {
        if (elementNames==null) {
            elementNames = new LinkedList();
            elementValues = new HashMap();
        }
        elementNames.add(elementName);
        elementValues.put(elementName, value);
        changed();
    }
    
    public Object getElement(String elementName) {
        if (elementValues!=null) {
            return elementValues.get(elementName);
        }
        return null;
    }
    
    /**
     * @return a value holder for all attributes of 
     * this deployment extension elements
     */
    public DynamicAttributesDescriptor getAttributes() {
        if (attributes==null) {
            attributes = new DynamicAttributesDescriptor();
            attributes.addObserver(this);
        }
        return attributes;
    }    
    
    /**
     * @return true if the deployment extension contains attributes
     */
    public boolean hasAttributes() {
        return attributes!=null;
    }
    
    /**
     * notification of changed from our attributes/elements
     * storage
     */
    public void update(Observable o, Object arg) {
        setChanged();
        notifyObservers();
    }
    
    /**
     * @return a meaningful string describing myself
     */
    public void print(StringBuffer toStringBuffer) {
        toStringBuffer.append("ExtensionElementDescriptor");
        toStringBuffer.append("\n");
        super.print(toStringBuffer);
        for (Iterator itr = getElementNames();itr.hasNext();) {
            toStringBuffer.append("\n  Element=").append(getElement((String) itr.next()));
        }
        if (hasAttributes()) {
            toStringBuffer.append("\n  Attributes = ").append(getAttributes());
        }
    }
}
