/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * MethodPermissionDescriptor.java
 *
 * Created on December 6, 2001, 2:32 PM
 */

package com.sun.enterprise.deployment;

import java.util.Vector;
import java.util.Iterator;
import java.util.Collection;

/**
 * This class defines a method permission information in the assembly 
 * descriptor
 *
 * @author  Jerome Dochez
 * @version 
 */
public class MethodPermissionDescriptor extends DescribableDescriptor {
         
    Vector methods = new Vector();
    Vector mps = new Vector() ;
    
    /** Creates new MethodPermissionDescriptor */
    public MethodPermissionDescriptor() {        
    }
    
    public void addMethod(MethodDescriptor aMethod) {
        methods.add(aMethod);
    }
    
    public void addMethods(Collection methods) {
        this.methods.addAll(methods);
    }
    
    public void addMethodPermission(MethodPermission mp) {
        mps.add(mp);
    }
    
    public MethodDescriptor[] getMethods() {
        MethodDescriptor[] array = new MethodDescriptor[methods.size()];
        methods.copyInto(array);
        return array;        
    }
    
    public MethodPermission[] getMethodPermissions() {
        MethodPermission[] array = new MethodPermission[mps.size()];
        mps.copyInto(array);
        return array;        
    }
        
    public void print(StringBuffer toStringBuffer) {
        StringBuffer buffer = toStringBuffer;
        buffer.append("Method Permission " + (getDescription()==null?"":getDescription()) );
        buffer.append("\nFor the following Permissions ");
        for (Iterator mpsIterator = mps.iterator();mpsIterator.hasNext();) {
            MethodPermission mp = (MethodPermission) mpsIterator.next();
            mp.print(buffer);
            buffer.append("\n");
        }
        buffer.append("\nFor the following ").append(methods.size()).append(" methods\n");
        for (Iterator methodsIterator = methods.iterator();methodsIterator.hasNext();) {
            MethodDescriptor md = (MethodDescriptor) methodsIterator.next();
            md.print(buffer);
            buffer.append("\n");
        }
    }
}
