/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */


package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.enterprise.util.io.FileUtils;

import javax.enterprise.deploy.shared.ModuleType;
import java.util.List;
import java.util.ArrayList;
import java.util.Collections;

/**
 * This descriptor represents contents for one persistence.xml file.
 *
 * @author Sanjeeb.Sahoo@Sun.COM
 */
public class PersistenceUnitsDescriptor extends RootDeploymentDescriptor {

    /** the parent descriptor that contains this descriptor */
    private RootDeploymentDescriptor parent;

    /**
     * The relative path from the parent {@link RootDeploymentDescriptor}
     * to the root of this persistence unit. e.g.
     * WEB-INF/classes -- if persistence.xml is in WEB-INF/classes/META-INF,
     * WEB-INF/lib/foo.jar -- if persistence.xml is in WEB-INF/lib/foo.jar/META-INF,
     * "" -- if persistence.xml is in some ejb.jar, or
     * util/bar.jar -- if persistence.xml is in a.ear/util/bar.jar
     */
    private String puRoot;

    List<PersistenceUnitDescriptor> persistenceUnitDescriptors =
            new ArrayList<PersistenceUnitDescriptor>();

    private static final String JPA_1_0 = "1.0";

    public PersistenceUnitsDescriptor() {
    }

    public RootDeploymentDescriptor getParent() {
        return parent;
    }

    public void setParent(RootDeploymentDescriptor parent) {
        this.parent = parent;
    }

    public String getPuRoot() {
        return puRoot;
    }

    public void setPuRoot(String puRoot) {
        this.puRoot = puRoot;
    }

    public String getDefaultSpecVersion() {
        return JPA_1_0;
    }

    public String getModuleID() {
        throw new RuntimeException();
    }

    public ModuleType getModuleType() {
        throw new RuntimeException();
    }

    public ClassLoader getClassLoader() {
        return parent.getClassLoader();
    }

    public boolean isApplication() {
        return false;
    }

    /**
     * This method does not do any validation like checking for unique names
     * of PersistenceUnits.
     * @param pud the PersistenceUnitDescriptor to be added.
     */
    public void addPersistenceUnitDescriptor(PersistenceUnitDescriptor pud){
        persistenceUnitDescriptors.add(pud);
        pud.setParent(this);
    }

    /**
     * @return an unmodifiable list.
     */
    public List<PersistenceUnitDescriptor> getPersistenceUnitDescriptors() {
        return Collections.unmodifiableList(persistenceUnitDescriptors);
    }

    /**
     * This is a utility method which calculates the absolute path of the
     * root of a PU. Absolute path is not the path with regards to
     * root of file system. It is the path from the root of the Java EE
     * application this persistence unit belongs to.
     * Like {@link #getPuRoot()} returned path always uses '/' as path separator.
     * @return the absolute path of the root of this persistence unit
     * @see #getPuRoot()
     */
    public String getAbsolutePuRoot() {
        RootDeploymentDescriptor rootDD = getParent();
        if(rootDD.isApplication()){
            return getPuRoot();
        } else {
            ModuleDescriptor module = BundleDescriptor.class.cast(rootDD).
                    getModuleDescriptor();
            if(module.isStandalone()) {
                return getPuRoot();
            } else {
                final String moduleLocation = FileUtils.makeFriendlyFileName(
                        module.getArchiveUri());
                return moduleLocation + '/' + getPuRoot(); // see we always '/'
            }
        }
    }

}
